/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.db.activerecord.sql;

import com.jfinal.kit.StrKit;
import com.jfinal.template.Directive;
import com.jfinal.template.Env;
import com.jfinal.template.Template;
import com.jfinal.template.expr.ast.Const;
import com.jfinal.template.expr.ast.Expr;
import com.jfinal.template.expr.ast.ExprList;
import com.jfinal.template.io.Writer;
import com.jfinal.template.stat.ParseException;
import com.jfinal.template.stat.Scope;
import java.util.Map;

public class SqlDirective
extends Directive {
    private String id;

    public void setExprList(ExprList exprList) {
        if (exprList.length() == 0) {
            throw new ParseException("The parameter of #sql directive can not be blank", this.location);
        }
        if (exprList.length() > 1) {
            throw new ParseException("Only one parameter allowed for #sql directive", this.location);
        }
        Expr expr = exprList.getExpr(0);
        if (!(expr instanceof Const) || !((Const)expr).isStr()) {
            throw new ParseException("The parameter of #sql directive must be String", this.location);
        }
        this.id = ((Const)expr).getStr();
    }

    public void exec(Env env, Scope scope, Writer writer) {
        String nameSpace = (String)scope.get((Object)"_NAME_SPACE_");
        String key = StrKit.isBlank((String)nameSpace) ? this.id : nameSpace + "." + this.id;
        Map sqlTemplateMap = (Map)scope.get((Object)"_SQL_TEMPLATE_MAP_");
        if (sqlTemplateMap.containsKey(key)) {
            throw new ParseException("Sql already exists with key : " + key, this.location);
        }
        sqlTemplateMap.put(key, new Template(env, this.stat));
    }

    public boolean hasEnd() {
        return true;
    }
}

