/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.db.activerecord.bean;

import com.litongjava.db.DbJsonObject;
import com.litongjava.db.activerecord.Row;
import com.litongjava.db.annotation.ATableField;
import com.litongjava.db.annotation.ATableName;
import com.litongjava.record.RecordConvert;
import com.litongjava.tio.utils.name.CamelNameUtils;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;

public class DefaultRecordConvert
implements RecordConvert {
    @Override
    public <T> T toJavaBean(Row record, Class<T> beanClass) {
        try {
            T bean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            ArrayList<Field> fieldList = new ArrayList<Field>();
            Field[] fields = beanClass.getDeclaredFields();
            fieldList.addAll(Arrays.asList(fields));
            for (Class<T> superClass = beanClass.getSuperclass(); superClass != null; superClass = superClass.getSuperclass()) {
                fieldList.addAll(Arrays.asList(superClass.getDeclaredFields()));
            }
            for (Field javaField : fieldList) {
                javaField.setAccessible(true);
                String fieldName = javaField.getName();
                ATableField tableFieldAnnotation = javaField.getAnnotation(ATableField.class);
                String columnName = tableFieldAnnotation != null && !tableFieldAnnotation.value().isEmpty() ? tableFieldAnnotation.value() : CamelNameUtils.toUnderscore((String)fieldName);
                Object fieldValue = record.get(columnName);
                if (fieldValue == null) continue;
                Class<?> javaFieldType = javaField.getType();
                if (tableFieldAnnotation != null && tableFieldAnnotation.targetType() != Object.class) {
                    fieldValue = this.convertType(fieldValue, tableFieldAnnotation.targetType());
                } else if (javaFieldType.equals(Short.class)) {
                    fieldValue = this.convertShortObject(fieldValue);
                } else if (javaFieldType.equals(Long.class)) {
                    fieldValue = this.convertLongObject(fieldValue);
                } else if (javaFieldType.equals(Boolean.class)) {
                    fieldValue = this.convertBooleanObject(fieldValue);
                } else if (javaFieldType.equals(Timestamp.class)) {
                    fieldValue = this.convertTimestampObject(fieldValue);
                } else if (javaFieldType.equals(DbJsonObject.class)) {
                    fieldValue = this.convertDbJsonObject(fieldValue);
                }
                try {
                    javaField.set(bean, fieldValue);
                }
                catch (IllegalArgumentException e) {
                    String name = fieldValue.getClass().getName();
                    String message = "Failed to set " + columnName + ",the value is " + fieldValue + " and value type is " + name + ", but taget value type is " + javaFieldType.toString();
                    throw new RuntimeException(message, e);
                }
            }
            return bean;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Error converting Record to Bean", e);
        }
    }

    private Object convertTimestampObject(Object fieldValue) {
        if (fieldValue != null && fieldValue instanceof Date) {
            return new Timestamp(((Date)fieldValue).getTime());
        }
        return fieldValue;
    }

    private Object convertLongObject(Object fieldValue) {
        if (fieldValue != null && fieldValue instanceof Integer) {
            return (long)((Integer)fieldValue).intValue();
        }
        return fieldValue;
    }

    private Object convertShortObject(Object fieldValue) {
        if (fieldValue != null && fieldValue instanceof Integer) {
            return ((Integer)fieldValue).shortValue();
        }
        return fieldValue;
    }

    private Boolean convertBooleanObject(Object fieldValue) {
        if (fieldValue != null && fieldValue instanceof Number) {
            if (fieldValue.equals(0)) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private Object convertDbJsonObject(Object fieldValue) {
        return new DbJsonObject(fieldValue.toString());
    }

    @Override
    public Row fromJavaBean(Object bean) {
        Field[] fields;
        Row record = new Row();
        Class<?> beanClass = bean.getClass();
        ATableName tableNameAnnotation = beanClass.getAnnotation(ATableName.class);
        if (tableNameAnnotation != null) {
            record.setTableName(tableNameAnnotation.value());
        } else {
            record.setTableName(CamelNameUtils.toUnderscore((String)beanClass.getSimpleName()));
        }
        for (Field field : fields = beanClass.getDeclaredFields()) {
            field.setAccessible(true);
            String fieldName = field.getName();
            ATableField tableFieldAnnotation = field.getAnnotation(ATableField.class);
            String columnName = tableFieldAnnotation != null && !tableFieldAnnotation.value().isEmpty() ? tableFieldAnnotation.value() : CamelNameUtils.toUnderscore((String)fieldName);
            try {
                Object value = field.get(bean);
                if (value == null) continue;
                record.set(columnName, value);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Error accessing field: " + fieldName, e);
            }
        }
        return record;
    }

    private Object convertType(Object value, Class<?> targetType) {
        if (targetType == Short.class) {
            return Short.valueOf(value.toString());
        }
        if (targetType == Integer.class) {
            return Integer.valueOf(value.toString());
        }
        return value;
    }
}

