/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.hotswap.wrapper.spring.boot;

import com.litongjava.hotswap.debug.Diagnostic;
import com.litongjava.hotswap.kit.HotSwapUtils;
import com.litongjava.hotswap.server.RestartServer;
import com.litongjava.hotswap.wrapper.spring.boot.SpringBootArgument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.context.ConfigurableApplicationContext;

public class SpringBootRestartServer
implements RestartServer {
    private static final Logger log = LoggerFactory.getLogger(SpringBootRestartServer.class);

    @Override
    public boolean isStarted() {
        return SpringBootArgument.getContext().isRunning();
    }

    @Override
    public void restart() {
        System.err.println("loading");
        long start = System.currentTimeMillis();
        SpringBootArgument.getContext().close();
        Class<?> clazz = SpringBootArgument.getBootClazz();
        String[] args = SpringBootArgument.getArgs();
        ClassLoader hotSwapClassLoader = HotSwapUtils.newClassLoader();
        if (Diagnostic.isDebug()) {
            log.info("new classLoader:{}", (Object)hotSwapClassLoader);
        }
        Thread.currentThread().setContextClassLoader(hotSwapClassLoader);
        ConfigurableApplicationContext context = SpringApplication.run(clazz, (String[])args);
        SpringBootArgument.setContext(context);
        long end = System.currentTimeMillis();
        System.err.println("Loading complete in " + (end - start) + " ms (^_^)\n");
    }

    @Override
    public void start(Class<?> primarySource, String[] args) {
    }

    @Override
    public void stop() {
    }
}

