/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.hotswap.wrapper.spring.boot;

import com.litongjava.hotswap.kit.HotSwapUtils;
import com.litongjava.hotswap.watcher.HotSwapWatcher;
import com.litongjava.hotswap.wrapper.spring.boot.SpringBootArgument;
import com.litongjava.hotswap.wrapper.spring.boot.SpringBootRestartServer;
import java.io.IOException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.io.support.PropertiesLoaderUtils;

public class SpringApplicationWrapper {
    private static final Logger log = LoggerFactory.getLogger(SpringApplicationWrapper.class);
    protected static volatile HotSwapWatcher hotSwapWatcher;

    public static ConfigurableApplicationContext run(Class<?> primarySource, String ... args) {
        String mode = null;
        for (String arg : args) {
            if (!"--mode=dev".equals(arg)) continue;
            mode = "dev";
            break;
        }
        if (mode == null) {
            try {
                Properties properties = PropertiesLoaderUtils.loadAllProperties((String)"config.properties");
                if (properties != null) {
                    mode = properties.getProperty("mode");
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return SpringApplicationWrapper.run(primarySource, args, "dev".equals(mode));
    }

    public static ConfigurableApplicationContext run(Class<?> primarySource, String[] args, Boolean isDev) {
        if (isDev.booleanValue()) {
            return SpringApplicationWrapper.runDev(primarySource, args);
        }
        return SpringApplication.run(primarySource, (String[])args);
    }

    public static ConfigurableApplicationContext run(Boolean isDev, Class<?> primarySource, String ... args) {
        return SpringApplicationWrapper.run(primarySource, args, isDev);
    }

    private static ConfigurableApplicationContext runDev(Class<?> primarySource, String[] args) {
        ClassLoader hotSwapClassLoader = HotSwapUtils.getClassLoader();
        log.info("hotSwapClassLoader:{}", (Object)hotSwapClassLoader);
        Thread.currentThread().setContextClassLoader(hotSwapClassLoader);
        ConfigurableApplicationContext context = SpringApplication.run(primarySource, (String[])args);
        SpringBootArgument.init(primarySource, args, context, true);
        if (hotSwapWatcher == null) {
            log.info("start hotSwapWatcher");
            hotSwapWatcher = new HotSwapWatcher(new SpringBootRestartServer());
            hotSwapWatcher.start();
        }
        return context;
    }
}

