/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.hotswap.wrapper.forkapp;

import com.litongjava.hotswap.kit.HotSwapUtils;
import com.litongjava.hotswap.server.RestartServer;
import com.litongjava.hotswap.watcher.HotSwapWatcher;
import com.litongjava.hotswap.wrapper.forkapp.ForkAppBootArgument;
import java.text.DecimalFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForkApp {
    private static final Logger log = LoggerFactory.getLogger(ForkApp.class);
    protected static HotSwapWatcher hotSwapWatcher;
    protected static DecimalFormat decimalFormat;

    protected static String getTimeSpent(long startTime) {
        float timeSpent = (float)(System.currentTimeMillis() - startTime) / 1000.0f;
        return decimalFormat.format(timeSpent);
    }

    public static void run(Class<?> primarySource, String[] args, boolean dev, RestartServer restarServer) {
        if (dev) {
            ClassLoader hotSwapClassLoader = HotSwapUtils.getClassLoader();
            Thread.currentThread().setContextClassLoader(hotSwapClassLoader);
            restarServer.start(primarySource, args);
            ForkAppBootArgument.init(primarySource, args, dev);
            if (hotSwapWatcher == null) {
                log.info("start hotSwapWatcher");
                hotSwapWatcher = new HotSwapWatcher(restarServer);
                hotSwapWatcher.start();
            }
        } else {
            restarServer.start(primarySource, args);
            ForkAppBootArgument.init(primarySource, args, dev);
        }
    }

    static {
        decimalFormat = new DecimalFormat("#.#");
    }
}

