/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.hotswap.wrapper.app;

import com.litongjava.hotswap.kit.HotSwapUtils;
import com.litongjava.hotswap.server.RestartServer;
import com.litongjava.hotswap.watcher.HotSwapWatcher;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.DecimalFormat;

public class SimpleApp {
    protected static volatile HotSwapWatcher hotSwapWatcher;
    protected static DecimalFormat decimalFormat;

    public static void run(final String clazzName, final String methodName) {
        ClassLoader hotSwapClassLoader = HotSwapUtils.getClassLoader();
        Thread.currentThread().setContextClassLoader(hotSwapClassLoader);
        try {
            SimpleApp.run(clazzName, methodName, hotSwapClassLoader);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
        }
        RestartServer restartServer = new RestartServer(){

            @Override
            public boolean isStarted() {
                return true;
            }

            @Override
            public void restart() {
                System.err.println("loading");
                long start = System.currentTimeMillis();
                ClassLoader hotSwapClassLoader = HotSwapUtils.newClassLoader();
                Thread.currentThread().setContextClassLoader(hotSwapClassLoader);
                try {
                    SimpleApp.run(clazzName, methodName, hotSwapClassLoader);
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    e.printStackTrace();
                }
                System.err.println("Loading complete in " + SimpleApp.getTimeSpent(start) + " seconds (^_^)\n");
            }

            @Override
            public void start(Class<?> primarySource, String[] args) {
            }

            @Override
            public void stop() {
            }
        };
        if (hotSwapWatcher == null) {
            hotSwapWatcher = new HotSwapWatcher(restartServer);
            hotSwapWatcher.start();
        }
    }

    private static void run(String className, String methodName, ClassLoader hotSwapClassLoader) throws ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        Class<?> clazz = hotSwapClassLoader.loadClass(className);
        Object callbaclObject = clazz.newInstance();
        Method method = clazz.getDeclaredMethod(methodName, new Class[0]);
        method.setAccessible(true);
        method.invoke(callbaclObject, new Object[0]);
    }

    protected static String getTimeSpent(long startTime) {
        float timeSpent = (float)(System.currentTimeMillis() - startTime) / 1000.0f;
        return decimalFormat.format(timeSpent);
    }

    static {
        decimalFormat = new DecimalFormat("#.#");
    }
}

