/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.hotswap.watcher;

import com.litongjava.hotswap.debug.Diagnostic;
import com.litongjava.hotswap.kit.UndertowKit;
import com.litongjava.hotswap.server.RestartServer;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HotSwapWatcher
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(HotSwapWatcher.class);
    protected RestartServer server;
    protected int watchingInterval = 500;
    protected List<Path> watchingPaths;
    private WatchKey watchKey;
    protected volatile boolean running = true;

    public HotSwapWatcher(RestartServer server) {
        this.setName("HotSwapWatcher");
        this.setDaemon(false);
        this.setPriority(10);
        this.server = server;
        this.watchingPaths = this.buildWatchingPaths();
    }

    protected List<Path> buildWatchingPaths() {
        String[] classPathArray;
        HashSet<String> watchingDirSet = new HashSet<String>();
        for (String classPath : classPathArray = System.getProperty("java.class.path").split(File.pathSeparator)) {
            this.buildDirs(new File(classPath.trim()), watchingDirSet);
        }
        ArrayList dirList = new ArrayList(watchingDirSet);
        Collections.sort(dirList);
        ArrayList<Path> pathList = new ArrayList<Path>(dirList.size());
        if (Diagnostic.isDebug()) {
            log.info("\u89c2\u5bdf\u7684\u76ee\u5f55\u6709:");
        }
        for (String dir : dirList) {
            if (Diagnostic.isDebug()) {
                System.out.println(dir);
            }
            pathList.add(Paths.get(dir, new String[0]));
        }
        return pathList;
    }

    private void buildDirs(File file, Set<String> watchingDirSet) {
        if (file.isDirectory() && !file.getName().contains("META-INF")) {
            File[] fileList;
            watchingDirSet.add(file.getPath());
            for (File f : fileList = file.listFiles()) {
                this.buildDirs(f, watchingDirSet);
            }
        }
    }

    @Override
    public void run() {
        try {
            this.doRun();
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    protected void doRun() throws IOException {
        ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();
        WatchService watcher = FileSystems.getDefault().newWatchService();
        if (Diagnostic.isDebug()) {
            log.info("\u6587\u4ef6\u89c2\u5bdf\u5668:{}", (Object)watcher);
        }
        this.addShutdownHook(watcher);
        for (Path path : this.watchingPaths) {
            path.register(watcher, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_CREATE);
        }
        executorService.scheduleAtFixedRate(() -> this.watch(watcher), 0L, 500L, TimeUnit.MILLISECONDS);
    }

    private void watch(WatchService watcher) {
        block3: {
            try {
                this.watchKey = watcher.take();
            }
            catch (Throwable e) {
                this.running = false;
                if (!(e instanceof InterruptedException)) break block3;
                Thread.currentThread().interrupt();
            }
        }
        if (this.watchKey != null) {
            this.process(watcher);
        }
        this.resetWatchKey();
    }

    private void process(WatchService watcher) {
        List<WatchEvent<?>> watchEvents = this.watchKey.pollEvents();
        if (Diagnostic.isDebug()) {
            log.info("Number of file modifications:{}", (Object)watchEvents.size());
        }
        for (WatchEvent<?> event : watchEvents) {
            boolean started;
            WatchEvent.Kind<?> kind = event.kind();
            String fileName = event.context().toString();
            if (Diagnostic.isDebug()) {
                log.info("{} event {},{}", new Object[]{watcher.toString(), kind.toString(), fileName});
            } else {
                log.info("watch event {},{}", (Object)kind.toString(), (Object)fileName);
            }
            if (kind == StandardWatchEventKinds.OVERFLOW || !fileName.endsWith(".class") || !(started = this.server.isStarted())) continue;
            log.info("restart server:{}", (Object)this.server);
            this.server.restart();
            this.resetWatchKey();
            while ((this.watchKey = watcher.poll()) != null) {
                List<WatchEvent<?>> pollEvents = this.watchKey.pollEvents();
                if (Diagnostic.isDebug()) {
                    log.info("\u8df3\u8fc7\u7684\u6587\u4ef6\u4fee\u6539\u4e2a\u6570:{}", (Object)pollEvents.size());
                }
                this.resetWatchKey();
            }
            break block0;
        }
    }

    private void resetWatchKey() {
        if (this.watchKey != null) {
            this.watchKey.reset();
            this.watchKey = null;
        }
    }

    protected void addShutdownHook(WatchService watcher) {
        Thread hook = new Thread(() -> {
            try {
                log.info("stop hotswapWatcher");
                watcher.close();
            }
            catch (Throwable e) {
                UndertowKit.doNothing(e);
            }
        });
        Runtime.getRuntime().addShutdownHook(hook);
    }

    public void exit() {
        this.running = false;
        try {
            this.interrupt();
        }
        catch (Throwable e) {
            UndertowKit.doNothing(e);
        }
    }
}

