/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.hotswap.watcher;

import java.io.File;
import java.util.ArrayList;

public class HotSwapResolver {
    protected String[] classPathDirs;
    protected static String[] systemClassPrefix = new String[]{"java.", "javax.", "sun.", "com.sun.", "com.jfinal.server.undertow."};
    protected static String[] hotSwapClassPrefix = new String[0];
    protected static String[] excludedHotSwapPrefixes = new String[0];

    public HotSwapResolver(String[] classPathDirs) {
        this.classPathDirs = classPathDirs != null ? classPathDirs : new String[0];
    }

    public boolean isSystemClass(String className) {
        for (String s : systemClassPrefix) {
            if (!className.startsWith(s)) continue;
            return true;
        }
        return false;
    }

    public boolean isHotSwapClass(String className) {
        for (String excludedPrefix : excludedHotSwapPrefixes) {
            if (!className.startsWith(excludedPrefix)) continue;
            return false;
        }
        for (String s : hotSwapClassPrefix) {
            if (!className.startsWith(s)) continue;
            return true;
        }
        return this.findClassInClassPathDirs(className);
    }

    protected boolean findClassInClassPathDirs(String className) {
        String fileName = className.replace('.', '/').concat(".class");
        if (this.classPathDirs.length == 1) {
            if (this.findFile(this.classPathDirs[0], fileName)) {
                return true;
            }
        } else {
            for (String dir : this.classPathDirs) {
                if (!this.findFile(dir, fileName)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean findFile(String filePath, String fileName) {
        File file = new File(filePath + fileName);
        return file.isFile();
    }

    public static synchronized void addSystemClassPrefix(String ... prefixs) {
        ArrayList<String> list = new ArrayList<String>();
        for (String s : systemClassPrefix) {
            list.add(s);
        }
        for (String prefix : prefixs) {
            list.add(prefix.trim());
        }
        systemClassPrefix = list.toArray(new String[list.size()]);
    }

    public static synchronized void addHotSwapClassPrefix(String ... prefixs) {
        ArrayList<String> list = new ArrayList<String>();
        for (String s : hotSwapClassPrefix) {
            list.add(s);
        }
        for (String prefix : prefixs) {
            list.add(prefix.trim());
        }
        hotSwapClassPrefix = list.toArray(new String[list.size()]);
    }

    public static synchronized void removeHotSwapClassPrefix(String ... prefixes) {
        ArrayList<String> list = new ArrayList<String>();
        for (String s : excludedHotSwapPrefixes) {
            list.add(s);
        }
        for (String prefix : prefixes) {
            list.add(prefix.trim());
        }
        excludedHotSwapPrefixes = list.toArray(new String[list.size()]);
    }
}

