/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.hotswap.kit;

import com.litongjava.hotswap.debug.Diagnostic;
import com.litongjava.hotswap.kit.ClassLoaderKit;
import com.litongjava.hotswap.kit.UndertowKit;
import com.litongjava.hotswap.watcher.HotSwapResolver;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HotSwapUtils {
    private static final Logger log = LoggerFactory.getLogger(HotSwapUtils.class);
    public static String[] args;
    protected static HotSwapResolver hotSwapResolver;
    protected static ClassLoaderKit classLoaderKit;
    protected static String[] classPathDirs;
    protected static String hotSwapClassPrefix;

    public static ClassLoader replaceClassLoader() {
        return HotSwapUtils.getClassLoaderKit().replaceClassLoader();
    }

    protected static ClassLoaderKit getClassLoaderKit() {
        if (classLoaderKit == null) {
            classLoaderKit = new ClassLoaderKit(HotSwapUtils.class.getClassLoader(), HotSwapUtils.getHotSwapResolver());
            if (Diagnostic.isDebug()) {
                log.info("create new kit:{}", (Object)classLoaderKit);
            }
        }
        return classLoaderKit;
    }

    public static HotSwapResolver getHotSwapResolver() {
        if (hotSwapResolver == null) {
            hotSwapResolver = new HotSwapResolver(HotSwapUtils.getClassPathDirs());
            if (hotSwapClassPrefix != null) {
                for (String prefix : hotSwapClassPrefix.split(",")) {
                    if (!HotSwapUtils.isEmpty(prefix)) continue;
                    HotSwapResolver.addHotSwapClassPrefix(prefix);
                }
            }
        }
        return hotSwapResolver;
    }

    private static boolean isEmpty(String str) {
        return str == null || "".equals(str);
    }

    public static String[] getClassPathDirs() {
        if (classPathDirs == null) {
            classPathDirs = UndertowKit.getClassPathDirs();
        }
        return classPathDirs;
    }

    public static ClassLoader getClassLoader() {
        return HotSwapUtils.getClassLoaderKit().getClassLoader();
    }

    public static ClassLoader newClassLoader() {
        classLoaderKit = new ClassLoaderKit(HotSwapUtils.class.getClassLoader(), HotSwapUtils.getHotSwapResolver());
        return classLoaderKit.getClassLoader();
    }

    public static boolean isDevelopmentEnvironment() {
        URL resource = HotSwapUtils.class.getClassLoader().getResource("");
        return resource != null && resource.toString().endsWith("/target/classes/");
    }

    static {
        hotSwapClassPrefix = null;
    }
}

