/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.table.services;

import com.litongjava.db.activerecord.Db;
import com.litongjava.table.model.DbTableStruct;
import com.litongjava.table.services.DbService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;

public class TableColumnService {
    private DbService dbService = new DbService();
    private Map<String, List<String>> tableColumns = new ConcurrentSkipListMap<String, List<String>>();

    public boolean isExists(String cloumn, String tableName) {
        List<String> list = this.tableColumns.get(tableName);
        if (list == null || list.size() == 0) {
            return this.getColumnsToMap(tableName, cloumn);
        }
        for (String field : list) {
            if (!field.equals(cloumn)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getColumnsToMap(String tableName, String column) {
        boolean ret = false;
        List<DbTableStruct> listRecord = this.dbService.getTableStruct(Db.use(), tableName);
        ArrayList<String> columns = new ArrayList<String>();
        for (DbTableStruct record : listRecord) {
            String field = record.getField();
            columns.add(field);
            if (!field.equals(column)) continue;
            ret = true;
        }
        DbService dbService = this.dbService;
        synchronized (dbService) {
            List<String> list = this.tableColumns.get(tableName);
            if (list == null || list.size() == 0) {
                this.tableColumns.put(tableName, columns);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean clear(String tableName) {
        DbService dbService = this.dbService;
        synchronized (dbService) {
            List<String> list = this.tableColumns.get(tableName);
            if (list != null && list.size() > 0) {
                this.tableColumns.remove(tableName);
            }
            return true;
        }
    }

    public void addColumn(String tableName, String field, String type, String comment) {
        this.clear(tableName);
        this.dbService.addColumn(tableName, field, type, comment);
    }
}

