/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.table.services;

import com.jfinal.kit.StrKit;
import com.litongjava.db.TableInput;
import com.litongjava.table.utils.ObjectUtils;
import java.util.Collections;
import java.util.List;

public class OperatorService {
    public void addOperator(StringBuffer where, List<Object> paramList, String fieldName, String operator, TableInput kv) {
        Object value = kv.get((Object)fieldName);
        if (!ObjectUtils.isEmpty(value)) {
            if ("eq".equals(operator)) {
                this.addWhereAndField(where, fieldName, "=");
                paramList.add(kv.remove((Object)fieldName));
            } else if ("ne".equals(operator)) {
                this.addWhereAndField(where, fieldName, "!=");
                paramList.add(kv.remove((Object)fieldName));
            } else if ("gt".equals(operator)) {
                this.addWhereAndField(where, fieldName, ">");
                paramList.add(kv.remove((Object)fieldName));
            } else if ("ge".equals(operator)) {
                this.addWhereAndField(where, fieldName, ">=");
                paramList.add(kv.remove((Object)fieldName));
            } else if ("lt".equals(operator)) {
                this.addWhereAndField(where, fieldName, "<");
                paramList.add(kv.remove((Object)fieldName));
            } else if ("le".equals(operator)) {
                this.addWhereAndField(where, fieldName, "<=");
                paramList.add(kv.remove((Object)fieldName));
            } else if ("bt".equals(operator)) {
                List list;
                Object remove = kv.remove((Object)fieldName);
                if (remove instanceof Object[]) {
                    Object[] valueArray = (Object[])remove;
                    if (valueArray.length > 1) {
                        this.addWhereFieldForWoOperator(where, fieldName, "between", "and");
                        paramList.add(valueArray[0]);
                        paramList.add(valueArray[1]);
                    }
                } else if (remove instanceof List && (list = (List)remove) != null && list.size() > 1) {
                    this.addWhereFieldForWoOperator(where, fieldName, "between", "and");
                    paramList.add(list.get(0));
                    paramList.add(list.get(1));
                }
            } else if ("nb".equals(operator)) {
                List list;
                Object remove = kv.remove((Object)fieldName);
                if (remove instanceof Object[]) {
                    Object[] valueArray = (Object[])remove;
                    if (valueArray.length > 1) {
                        this.addWhereFieldForWoOperator(where, fieldName, "not between", "and");
                        paramList.add(valueArray[0]);
                        paramList.add(valueArray[1]);
                    }
                } else if (remove instanceof List && (list = (List)remove) != null && list.size() > 1) {
                    this.addWhereFieldForWoOperator(where, fieldName, "not between", "and");
                    paramList.add(list.get(0));
                    paramList.add(list.get(1));
                }
            } else if ("ct".equals(operator)) {
                this.addWhereAndField(where, fieldName, "like");
                paramList.add("%" + kv.remove((Object)fieldName) + "%");
            } else if ("sw".equals(operator)) {
                value = kv.remove((Object)fieldName);
                if (StrKit.notNull((Object[])new Object[]{kv.remove((Object)fieldName)})) {
                    this.addWhereAndField(where, fieldName, "like");
                    paramList.add("%" + value);
                }
            } else if ("ew".equals(operator)) {
                value = kv.remove((Object)fieldName);
                this.addWhereAndField(where, fieldName, "like");
                paramList.add(value + "%");
            } else if ("ol".equals(operator)) {
                value = kv.remove((Object)fieldName);
                if (value instanceof Object[]) {
                    Object[] valueArray = (Object[])value;
                    this.addWhereOrField(where, fieldName, "like", valueArray);
                    Collections.addAll(paramList, valueArray);
                }
            } else if ("nk".equals(operator)) {
                value = kv.remove((Object)fieldName);
                this.addWhereAndField(where, fieldName, "not like");
                paramList.add(value);
            } else if ("il".equals(operator)) {
                value = kv.remove((Object)fieldName);
                if (value instanceof Object[]) {
                    Object[] valueArray = (Object[])value;
                    this.addWhereInField(where, fieldName, "in", valueArray);
                    Collections.addAll(paramList, valueArray);
                }
            } else if ("ni".equals(operator)) {
                value = kv.remove((Object)fieldName);
                if (value instanceof Object[]) {
                    Object[] valueArray = (Object[])value;
                    this.addWhereInField(where, fieldName, "not in", valueArray);
                    Collections.addAll(paramList, valueArray);
                }
            } else if ("nl".equals(operator)) {
                this.addWhereNotValueField(where, fieldName, "is null", "and");
            } else if ("nn".equals(operator)) {
                this.addWhereNotValueField(where, fieldName, "is not null", "and");
            } else if ("ey".equals(operator)) {
                this.addWhereEmptyField(where, fieldName);
            } else if ("ny".equals(operator)) {
                this.addWhereNotEmptyField(where, fieldName);
            } else if ("nt".equals(operator)) {
                this.addWhereNotTrue(where, fieldName);
            } else if ("nf".equals(operator)) {
                this.addWhereNotFalse(where, fieldName);
            }
        } else if ("nl".equals(operator)) {
            this.addWhereNotValueField(where, fieldName, "is null");
        } else if ("nn".equals(operator)) {
            this.addWhereNotValueField(where, fieldName, "is not null");
        } else if ("ey".equals(operator)) {
            this.addWhereEmptyField(where, fieldName);
        } else if ("ny".equals(operator)) {
            this.addWhereNotEmptyField(where, fieldName);
        } else if ("nt".equals(operator)) {
            this.addWhereNotTrue(where, fieldName);
        } else if ("nf".equals(operator)) {
            this.addWhereNotFalse(where, fieldName);
        }
    }

    private void addWhereInField(StringBuffer sql, String fieldName, String operator, Object[] valueArray) {
        if (!sql.toString().endsWith("where ")) {
            sql.append(" and ");
        }
        String format = "%s %s (%s)";
        String questionMarks = String.join((CharSequence)",", Collections.nCopies(valueArray.length, "?"));
        sql.append(String.format(format, fieldName, operator, questionMarks));
    }

    public void addWhereOrField(StringBuffer sql, String fieldName, String operator, Object[] valueArray) {
        if (!sql.toString().endsWith("where ")) {
            sql.append(" and ");
        }
        sql.append("(");
        String format = "%s %s ?";
        sql.append(String.format(format, fieldName, operator));
        String orFormat = "or %s %s ?";
        for (int i = 1; i < valueArray.length; ++i) {
            sql.append(String.format(orFormat, fieldName, operator));
        }
        sql.append(")");
    }

    public void addWhereAndField(StringBuffer sql, String fieldName, String operator) {
        this.addWhereField(sql, fieldName, operator, "and");
    }

    public void addWhereOrField(StringBuffer sql, String fieldName, String operator) {
        this.addWhereField(sql, fieldName, operator, "or");
    }

    public void addWhereField(StringBuffer sql, String fieldName, String operator, String logic) {
        if (!sql.toString().endsWith("where ")) {
            sql.append(" ").append(logic).append(" ");
        }
        String format = "%s %s ?";
        sql.append(String.format(format, fieldName, operator));
    }

    public void addWhereNotValueField(StringBuffer sql, String fieldName, String operator) {
        String format = "%s %s";
        sql.append(String.format(format, fieldName, operator));
    }

    public void addWhereNotValueField(StringBuffer sql, String fieldName, String operator, String logic) {
        if (!sql.toString().endsWith("where ")) {
            sql.append(" ").append(logic).append(" ");
        }
        String format = "%s %s";
        sql.append(String.format(format, fieldName, operator));
    }

    public void addWhereFieldForWoOperator(StringBuffer sql, String fieldName, String operator1, String operator2) {
        if (!sql.toString().endsWith("where ")) {
            sql.append(" and ");
        }
        String format = "%s %s ? %s ?";
        sql.append(String.format(format, fieldName, operator1, operator2));
    }

    public void addWhereNotEmptyField(StringBuffer sql, String fieldName) {
        if (!sql.toString().endsWith("where ")) {
            sql.append(" and ");
        }
        String format = "%s is not null and %s != ''";
        sql.append(String.format(format, fieldName, fieldName));
    }

    public void addWhereNotTrue(StringBuffer sql, String fieldName) {
        if (!sql.toString().endsWith("where ")) {
            sql.append(" and ");
        }
        String format = "%s is not true";
        sql.append(String.format(format, fieldName, fieldName));
    }

    public void addWhereNotFalse(StringBuffer sql, String fieldName) {
        if (!sql.toString().endsWith("where ")) {
            sql.append(" and ");
        }
        String format = "%s is not false";
        sql.append(String.format(format, fieldName, fieldName));
    }

    public void addWhereEmptyField(StringBuffer sql, String fieldName) {
        if (!sql.toString().endsWith("where ")) {
            sql.append(" and ");
        }
        String format = "%s is null or %s = ''";
        sql.append(String.format(format, fieldName, fieldName));
    }
}

