/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.table.services;

import com.litongjava.db.activerecord.Db;
import com.litongjava.table.model.DbTableStruct;
import com.litongjava.table.services.DbService;
import com.litongjava.table.services.PrimaryKeyService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class DbTableService {
    private DbService dbService = new DbService();
    private PrimaryKeyService primaryKeyService = new PrimaryKeyService();

    public List<Map<String, Object>> columns(String f) {
        List<DbTableStruct> columns = this.dbService.getTableStruct(Db.use(), f);
        ArrayList<Map<String, Object>> tableItems = new ArrayList<Map<String, Object>>(columns.size());
        for (DbTableStruct record : columns) {
            String field = record.getField();
            String fieldType = record.getType();
            String name = this.getName(field);
            String type = this.getType(fieldType);
            type = type.equals("date") ? "dateTime" : (type.equals("text") ? "textarea" : "text");
            LinkedHashMap<String, String> tableItem = new LinkedHashMap<String, String>();
            tableItem.put("title", name);
            tableItem.put("dataIndex", field);
            tableItem.put("valueType", type);
            tableItems.add(tableItem);
        }
        return tableItems;
    }

    public Map<String, Object> getTableConfig(String f, String tableName, String lang) {
        List<DbTableStruct> columns = this.dbService.getTableStruct(Db.use(), tableName);
        ArrayList queryItems = new ArrayList(columns.size());
        ArrayList tableItems = new ArrayList(columns.size());
        ArrayList formItems = new ArrayList(columns.size());
        LinkedHashMap<String, String> operator = new LinkedHashMap<String, String>();
        for (DbTableStruct record : columns) {
            String field = record.getField();
            String fieldType = record.getType();
            String name = this.getName(field);
            String key = this.getKey(field, false);
            String type = this.getType(fieldType);
            LinkedHashMap<String, Object> queryItem = new LinkedHashMap<String, Object>();
            queryItem.put("name", name);
            queryItem.put("key", key);
            queryItem.put("type", type);
            queryItem.put("show", true);
            LinkedHashMap<String, Object> tableItem = new LinkedHashMap<String, Object>();
            tableItem.put("name", name);
            tableItem.put("key", key);
            tableItem.put("type", type);
            tableItem.put("align", "center");
            tableItem.put("show", true);
            LinkedHashMap<String, Object> formItem = new LinkedHashMap<String, Object>();
            formItem.put("name", name);
            formItem.put("key", key);
            formItem.put("type", type);
            formItem.put("show", true);
            if ("date".equals(type)) {
                operator.put(key + "Op", "bt");
                queryItem.put("prop", this.getQueryItemDateProp(lang));
                formItem.put("prop", this.getFormItemDateProp(lang));
            } else {
                queryItem.put("placeholder", this.getPlaceholder(name, lang));
                formItem.put("placeholder", this.getPlaceholder(name, lang));
                if (fieldType.startsWith("varchar")) {
                    operator.put(key + "Op", "ew");
                }
            }
            queryItems.add(queryItem);
            tableItems.add(tableItem);
            formItems.add(formItem);
        }
        String primaryKeyName = this.primaryKeyService.getPrimaryKeyName(tableName);
        String primaryKeyColumnType = this.primaryKeyService.getPrimaryKeyColumnType(tableName);
        LinkedHashMap<String, Object> query = new LinkedHashMap<String, Object>();
        query.put("show", false);
        query.put("items", queryItems);
        query.put("operator", operator);
        query.put("button", this.getButton(lang));
        LinkedHashMap<String, Object> toolBar = new LinkedHashMap<String, Object>();
        toolBar.put("show", true);
        toolBar.put("addButtonShow", true);
        toolBar.put("exportButtonShow", true);
        toolBar.put("exportAllButtonShow", true);
        toolBar.put("addButtonName", this.getAddButtonName(lang));
        toolBar.put("exportButtonName", this.getExportButtonName(lang));
        toolBar.put("exportAllButtonName", this.getExportAllButtonName(lang));
        LinkedHashMap<String, Object> table = new LinkedHashMap<String, Object>();
        table.put("selectionShow", true);
        table.put("numberShow", true);
        table.put("items", tableItems);
        table.put("operation", this.getOperation(lang));
        LinkedHashMap<String, Object> form = new LinkedHashMap<String, Object>();
        form.put("width", "1000px");
        form.put("labelWidth", "150px");
        form.put("items", formItems);
        form.put("button", this.getFormButton(lang));
        LinkedHashMap<String, Object> config = new LinkedHashMap<String, Object>();
        config.put("f", f);
        config.put("idName", primaryKeyName);
        config.put("idType", primaryKeyColumnType);
        config.put("tableAlias", this.getName(tableName));
        config.put("pageUri", "/api/table/" + f + "/page");
        config.put("getUri", "/api/table/" + f + "/get");
        config.put("createUri", "/api/table/" + f + "/create");
        config.put("updateUri", "/api/table/" + f + "/update");
        config.put("deleteUri", "/api/table/" + f + "/delete");
        config.put("exportExcelUri", "/api/table/" + f + "/export-excel");
        config.put("exportTableExcelUri", "/api/table/" + f + "/export-table-excel");
        config.put("query", query);
        config.put("toolBar", toolBar);
        config.put("table", table);
        config.put("form", form);
        return config;
    }

    private Map<String, String> getButton(String lang) {
        LinkedHashMap<String, String> hashMap = new LinkedHashMap<String, String>();
        if ("zh-CN".equals(lang)) {
            hashMap.put("queryButtonName", "\u67e5\u8be2");
            hashMap.put("resetButtonName", "\u91cd\u7f6e");
        } else {
            hashMap.put("queryButtonName", "Query");
            hashMap.put("resetButtonName", "Reset");
        }
        return hashMap;
    }

    private Object getFormButton(String lang) {
        LinkedHashMap<String, String> hashMap = new LinkedHashMap<String, String>();
        if ("zh-CN".equals(lang)) {
            hashMap.put("confimButtonName", "\u786e\u8ba4");
            hashMap.put("cancelButtonName", "\u53d6\u6d88");
        } else {
            hashMap.put("confimButtonName", "Comfirm");
            hashMap.put("cancelButtonName", "Cancel");
        }
        return hashMap;
    }

    private String getName(String field) {
        return Arrays.stream(field.split("_")).map(word -> word.substring(0, 1).toUpperCase() + word.substring(1)).collect(Collectors.joining(" "));
    }

    private String getKey(String field, boolean toCamel) {
        if (toCamel) {
            String[] words = field.split("_");
            StringBuilder key = new StringBuilder(words[0]);
            for (int i = 1; i < words.length; ++i) {
                key.append(Character.toUpperCase(words[i].charAt(0))).append(words[i].substring(1));
            }
            return key.toString();
        }
        return field;
    }

    private String getPlaceholder(String name, String lang) {
        if ("zh-CN".equals(lang)) {
            return "\u8bf7\u8f93\u5165 " + name;
        }
        return "Please Input " + name;
    }

    private String getType(String type) {
        if (type.startsWith("date") || type.startsWith("timestamp") || type.startsWith("datetime")) {
            return "date";
        }
        if ("tinyint(1)".equals(type)) {
            return "bool";
        }
        if ("int".equals(type) || "integer".equals(type)) {
            return "int";
        }
        if ("smallint".equals(type)) {
            return "short";
        }
        if ("bigint".equals(type)) {
            return "long";
        }
        if ("character varying".equals(type) || "varchar".equals(type)) {
            return "varchar";
        }
        return type;
    }

    private Map<String, Object> getQueryItemDateProp(String lang) {
        LinkedHashMap<String, Object> hashMap = new LinkedHashMap<String, Object>();
        hashMap.put("type", "daterange");
        hashMap.put("valueFormat", "yyyy-MM-dd HH:mm:ss");
        hashMap.put("rangeSeparator", "-");
        if ("zh-CN".equals(lang)) {
            hashMap.put("startPlaceholder", "\u5f00\u59cb\u65e5\u671f");
            hashMap.put("endPlaceholder", "\u7ed3\u675f\u65e5\u671f");
        } else {
            hashMap.put("startPlaceholder", "Start Date");
            hashMap.put("endPlaceholder", "End Date");
        }
        hashMap.put("defaultTime", new String[]{"00:00:00", "23:59:59"});
        return hashMap;
    }

    private Map<String, Object> getFormItemDateProp(String lang) {
        LinkedHashMap<String, Object> hashMap = new LinkedHashMap<String, Object>();
        hashMap.put("type", "datetime");
        hashMap.put("valueFormat", "timestamp");
        return hashMap;
    }

    private Map<String, Object> getOperation(String lang) {
        LinkedHashMap<String, Object> hashMap = new LinkedHashMap<String, Object>();
        hashMap.put("show", true);
        hashMap.put("align", "right");
        hashMap.put("updateButtonShow", true);
        hashMap.put("deleteButtonShow", true);
        if ("zh-CN".equals(lang)) {
            hashMap.put("updateButtonName", "\u4fee\u6539");
            hashMap.put("deleteButtonName", "\u5220\u9664");
        } else {
            hashMap.put("updateButtonName", "Edit");
            hashMap.put("deleteButtonName", "Delete");
        }
        return hashMap;
    }

    private String getAddButtonName(String lang) {
        if ("zh-CN".equals(lang)) {
            return "\u589e\u52a0";
        }
        return "Add";
    }

    private String getExportButtonName(String lang) {
        if ("zh-CN".equals(lang)) {
            return "\u5bfc\u51fa";
        }
        return "Export";
    }

    private Object getExportAllButtonName(String lang) {
        if ("zh-CN".equals(lang)) {
            return "\u5168\u90e8\u5bfc\u51fa";
        }
        return "Export All";
    }

    public String getFieldType(String f, String key) {
        List<DbTableStruct> columns = this.dbService.getTableStruct(Db.use(), f);
        for (DbTableStruct record : columns) {
            String field = record.getField();
            String fieldType = record.getType();
            if (!key.equals(field)) continue;
            return this.getType(fieldType);
        }
        return null;
    }
}

