/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.table.services;

import com.litongjava.db.TableInput;
import com.litongjava.db.activerecord.DbPro;
import com.litongjava.db.activerecord.dialect.PostgreSqlDialect;
import com.litongjava.table.model.DataQueryRequest;
import com.litongjava.table.model.Sql;
import com.litongjava.table.services.OperatorService;
import com.litongjava.table.utils.ObjectUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class DbSqlService {
    private OperatorService operatorService = new OperatorService();

    private void removeKv(TableInput kv) {
        kv.remove((Object)"page_no");
        kv.remove((Object)"page_size");
        kv.remove((Object)"table_name");
        kv.remove((Object)"order_by");
        kv.remove((Object)"is_asc");
        kv.remove((Object)"columns");
    }

    public Sql getWhereClause(DbPro dbPro, DataQueryRequest queryRequest, TableInput kv) {
        this.removeKv(kv);
        Sql whereClause = this.getWhereQueryClause(dbPro, kv);
        StringBuffer where = whereClause.getWhere();
        if (where.toString().equals("where ")) {
            where.setLength(0);
        }
        String orderBy = queryRequest.getOrderBy();
        Boolean isAsc = queryRequest.getIsAsc();
        String groupBy = queryRequest.getGroupBy();
        Integer pageNo = queryRequest.getPageNo();
        Integer pageSize = queryRequest.getPageSize();
        if (orderBy != null) {
            where.append(" order by ").append(orderBy);
        }
        if (isAsc != null && !isAsc.booleanValue()) {
            where.append(" desc");
        }
        if (groupBy != null) {
            where.append(" group by ").append(groupBy);
        }
        if (pageNo != null && pageSize != null) {
            int offset = (pageNo - 1) * pageSize;
            where.append(" limit ").append(pageSize).append(" offset ").append(offset);
        } else if (pageSize != null) {
            where.append(" limit ").append(pageSize);
        }
        whereClause.setWhere(where);
        return whereClause;
    }

    public Sql getWhereQueryClause(DbPro dbPro, TableInput kv) {
        StringBuffer sql = new StringBuffer();
        sql.append("where ");
        ArrayList<Object> paramList = new ArrayList<Object>();
        HashMap notEqualsMap = new HashMap();
        Iterator iterator = kv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            String string = (String)entry.getKey();
            Object value = entry.getValue();
            if (!string.endsWith("_op")) continue;
            notEqualsMap.put(string, value);
            iterator.remove();
        }
        for (Map.Entry entry : notEqualsMap.entrySet()) {
            String key = (String)entry.getKey();
            String field = key.substring(0, key.lastIndexOf("_"));
            this.operatorService.addOperator(sql, paramList, field, (String)entry.getValue(), kv);
        }
        String searchKey = kv.getSearchKey();
        String string = kv.getStr((Object)"search_key_logic");
        if (searchKey != null) {
            kv.remove((Object)"search_key");
            if (dbPro.getConfig().getDialect() instanceof PostgreSqlDialect) {
                if (!sql.toString().endsWith("where ")) {
                    if ("or".equals(string)) {
                        sql.append(" ").append(string).append(" ");
                    } else {
                        sql.append(" ").append("and").append(" ");
                    }
                }
                sql.append("search_vector @@ to_tsquery('english', ?)");
                paramList.add(searchKey);
            }
        }
        Iterator iterator2 = kv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Object fieldValue;
            Map.Entry entry = (Map.Entry)iterator2.next();
            String fieldName = (String)entry.getKey();
            if (fieldName.endsWith("_logic") || ObjectUtils.isEmpty(fieldValue = entry.getValue())) continue;
            String logic = (String)kv.get((Object)(fieldName + "_logic"));
            if ("or".equals(logic)) {
                this.operatorService.addWhereOrField(sql, fieldName, "=");
            } else {
                this.operatorService.addWhereAndField(sql, fieldName, "=");
            }
            paramList.add(fieldValue);
            iterator2.remove();
        }
        if (paramList.size() > 0) {
            return new Sql(sql, paramList);
        }
        return new Sql(sql);
    }
}

