/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.table.services;

import com.litongjava.db.activerecord.Db;
import com.litongjava.db.activerecord.DbPro;
import com.litongjava.db.activerecord.Row;
import com.litongjava.db.activerecord.dialect.Dialect;
import com.litongjava.db.activerecord.dialect.MysqlDialect;
import com.litongjava.db.activerecord.dialect.PostgreSqlDialect;
import com.litongjava.db.activerecord.dialect.Sqlite3Dialect;
import com.litongjava.db.activerecord.dialect.TdEngineDialect;
import com.litongjava.db.utils.MarkdownTableUtils;
import com.litongjava.model.page.Page;
import com.litongjava.table.model.DbTableStruct;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DbService {
    private Map<String, List<DbTableStruct>> dbTableStructCache = new ConcurrentHashMap<String, List<DbTableStruct>>();

    public Map<String, List<Row>> getAllTableColumns(DbPro dbPro) {
        String[] tableNames;
        HashMap<String, List<Row>> retval = new HashMap<String, List<Row>>();
        for (String name : tableNames = this.tableNames(dbPro)) {
            retval.put(name, this.getTableColumns(dbPro, name));
        }
        return retval;
    }

    public String getAllTableDataExamplesOfMarkdown(DbPro dbPro) {
        StringBuilder markdown = new StringBuilder();
        String[] tableNames = this.tableNames(dbPro);
        for (int i = 0; i < tableNames.length; ++i) {
            List records;
            String name = tableNames[i];
            Page paginate = dbPro.paginate(1, 1, "select *", "from " + name);
            if (paginate == null || (records = paginate.getList()) == null) continue;
            String markdownTable = MarkdownTableUtils.to((List)records);
            markdown.append("**" + (i + 1) + " ." + name + "**\n");
            markdown.append(markdownTable);
        }
        return markdown.toString();
    }

    public String getAllTableColumnsOfMarkdown(DbPro dbPro) {
        StringBuilder markdown = new StringBuilder();
        String[] tableNames = this.tableNames(dbPro);
        for (int i = 0; i < tableNames.length; ++i) {
            String name = tableNames[i];
            List<Row> tableColumns = this.getTableColumns(dbPro, name);
            String markdownTable = MarkdownTableUtils.to(tableColumns);
            markdown.append("**" + (i + 1) + " ." + name + "**\n");
            markdown.append(markdownTable);
        }
        return markdown.toString();
    }

    public List<DbTableStruct> getPrimaryKey(DbPro dbPro, String tableName) {
        ArrayList<DbTableStruct> ret = new ArrayList<DbTableStruct>();
        List<DbTableStruct> columns = this.getTableStruct(dbPro, tableName);
        if (columns.size() < 1) {
            throw new RuntimeException("columns of " + tableName + " size is 0");
        }
        for (DbTableStruct record : columns) {
            String key = record.getKey();
            if (!"PRI".equals(key) && !"1".equals(key) && !"id".equals(key)) continue;
            DbTableStruct tableColumn = new DbTableStruct();
            tableColumn.setField(record.getField());
            tableColumn.setType(record.getType());
            tableColumn.setKey(key);
            ret.add(tableColumn);
        }
        return ret;
    }

    private String[] toArray(List<String> list) {
        int size = list.size();
        String[] ret = new String[size];
        for (int i = 0; i < size; ++i) {
            ret[i] = list.get(i);
        }
        return ret;
    }

    public String[] tableNames(DbPro dbPro) {
        String sql;
        List tables = null;
        Dialect dialect = dbPro.getConfig().getDialect();
        if (dialect instanceof PostgreSqlDialect) {
            sql = "SELECT table_name FROM information_schema.tables WHERE table_schema = 'public' AND table_type = 'BASE TABLE';";
            tables = Db.find((String)sql);
        } else {
            sql = "show tables";
            tables = Db.find((String)sql);
        }
        int size = tables.size();
        String[] retval = new String[size];
        for (int i = 0; i < size; ++i) {
            retval[i] = (String)((Row)tables.get(i)).getColumnValues()[0];
        }
        return retval;
    }

    public String[] tableNames() {
        return this.tableNames(Db.use());
    }

    public List<DbTableStruct> getTableStruct(DbPro dbPro, String tableName) {
        Dialect dialect = dbPro.getConfig().getDialect();
        String cacheKey = dbPro.getConfig().getName() + "_" + tableName;
        List<DbTableStruct> ret = this.dbTableStructCache.get(cacheKey);
        if (ret == null || ret.size() < 1) {
            ret = new ArrayList<DbTableStruct>();
            List<Row> columns = this.getTableColumns(dbPro, tableName);
            if (dialect instanceof PostgreSqlDialect) {
                for (Row record : columns) {
                    DbTableStruct tableColumn = new DbTableStruct();
                    tableColumn.setField(record.getStr("field"));
                    tableColumn.setType(record.getStr("type"));
                    String key = record.getStr("key");
                    tableColumn.setKey(key);
                    ret.add(tableColumn);
                }
            } else if (dialect instanceof Sqlite3Dialect) {
                for (Row record : columns) {
                    DbTableStruct tableColumn = new DbTableStruct();
                    tableColumn.setField(record.getStr("name"));
                    tableColumn.setType(record.getStr("type"));
                    tableColumn.setIsNull(record.getStr("notnull"));
                    tableColumn.setDefaultValue(record.getStr("dflt_value"));
                    tableColumn.setKey(record.getStr("pk"));
                    ret.add(tableColumn);
                }
            } else if (dialect instanceof MysqlDialect) {
                for (Row record : columns) {
                    DbTableStruct tableColumn = new DbTableStruct();
                    tableColumn.setField(record.getStr("Field"));
                    tableColumn.setType(record.getStr("Type"));
                    tableColumn.setIsNull(record.getStr("Null"));
                    tableColumn.setDefaultValue(record.getStr("Default"));
                    tableColumn.setKey(record.getStr("Key"));
                    ret.add(tableColumn);
                }
            } else {
                for (Row record : columns) {
                    DbTableStruct tableColumn = new DbTableStruct();
                    tableColumn.setField(record.getStr("field"));
                    tableColumn.setType(record.getStr("type"));
                    String key = record.getStr("key");
                    tableColumn.setKey(key);
                    ret.add(tableColumn);
                }
            }
            this.dbTableStructCache.putIfAbsent(cacheKey, ret);
        }
        return ret;
    }

    public List<Row> getTableColumns(DbPro dbPro, String tableName) {
        Dialect dialect = dbPro.getConfig().getDialect();
        List records = null;
        if (dialect instanceof PostgreSqlDialect) {
            String sql = "SELECT column_name as Field, data_type as Type, is_nullable as Null, column_default as Default, CASE WHEN column_name = ANY (ARRAY(SELECT kcu.column_name FROM information_schema.key_column_usage AS kcu JOIN information_schema.table_constraints AS tc ON kcu.constraint_name = tc.constraint_name WHERE tc.table_name = ? AND tc.constraint_type = 'PRIMARY KEY')) THEN 'PRI' ELSE '' END AS key FROM information_schema.columns WHERE table_name = ? and table_schema = ?;";
            records = dbPro.find(sql, new Object[]{tableName, tableName, "public"});
        } else if (!(dialect instanceof TdEngineDialect)) {
            if (dialect instanceof Sqlite3Dialect) {
                String sql = "PRAGMA table_info(" + tableName + ")";
                records = dbPro.find(sql);
            } else {
                String sql = "show columns from " + tableName;
                records = dbPro.find(sql);
            }
        }
        return records;
    }

    public void addColumn(String tableName, String field, String type, String comment) {
        String sql = "ALTER TABLE %s ADD COLUMN `%s` %s comment '%s';";
        sql = String.format(sql, tableName, field, type, comment);
        Db.update((String)sql);
    }

    public String[] getJsonField(DbPro dbPro, String tableName) {
        List<DbTableStruct> columns = this.getTableStruct(dbPro, tableName);
        if (columns.size() < 1) {
            throw new RuntimeException("columns of " + tableName + " size is 0");
        }
        ArrayList<String> fields = new ArrayList<String>();
        for (DbTableStruct record : columns) {
            String type = record.getType();
            if (!"jsonb".equals(type) && !"json".equals(type)) continue;
            String field = record.getField();
            fields.add(field);
        }
        String[] jsonFields = new String[fields.size()];
        for (int i = 0; i < fields.size(); ++i) {
            jsonFields[i] = (String)fields.get(i);
        }
        return jsonFields;
    }
}

