/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.table.model;

import com.litongjava.db.TableInput;

public class DataPageRequest {
    private Integer pageNo;
    private Integer pageSize;

    public DataPageRequest() {
        this.pageNo = 1;
        this.pageSize = 10;
    }

    public DataPageRequest(TableInput kv) {
        Object pageNo = kv.remove((Object)"page_no");
        this.pageNo = this.getIntegerValue(pageNo, 1);
        Object pageSize = kv.remove((Object)"page_size");
        this.pageSize = this.getIntegerValue(pageSize, 10);
    }

    private Integer getIntegerValue(Object v, Integer defaultValue) {
        if (v == null) {
            return defaultValue;
        }
        if (v instanceof Integer) {
            return (Integer)v;
        }
        return Integer.parseInt((String)v);
    }

    public static DataPageRequestBuilder builder() {
        return new DataPageRequestBuilder();
    }

    public Integer getPageNo() {
        return this.pageNo;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setPageNo(Integer pageNo) {
        this.pageNo = pageNo;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataPageRequest)) {
            return false;
        }
        DataPageRequest other = (DataPageRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$pageNo = this.getPageNo();
        Integer other$pageNo = other.getPageNo();
        if (this$pageNo == null ? other$pageNo != null : !((Object)this$pageNo).equals(other$pageNo)) {
            return false;
        }
        Integer this$pageSize = this.getPageSize();
        Integer other$pageSize = other.getPageSize();
        return !(this$pageSize == null ? other$pageSize != null : !((Object)this$pageSize).equals(other$pageSize));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DataPageRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $pageNo = this.getPageNo();
        result = result * 59 + ($pageNo == null ? 43 : ((Object)$pageNo).hashCode());
        Integer $pageSize = this.getPageSize();
        result = result * 59 + ($pageSize == null ? 43 : ((Object)$pageSize).hashCode());
        return result;
    }

    public String toString() {
        return "DataPageRequest(pageNo=" + this.getPageNo() + ", pageSize=" + this.getPageSize() + ")";
    }

    public DataPageRequest(Integer pageNo, Integer pageSize) {
        this.pageNo = pageNo;
        this.pageSize = pageSize;
    }

    public static class DataPageRequestBuilder {
        private Integer pageNo;
        private Integer pageSize;

        DataPageRequestBuilder() {
        }

        public DataPageRequestBuilder pageNo(Integer pageNo) {
            this.pageNo = pageNo;
            return this;
        }

        public DataPageRequestBuilder pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public DataPageRequest build() {
            return new DataPageRequest(this.pageNo, this.pageSize);
        }

        public String toString() {
            return "DataPageRequest.DataPageRequestBuilder(pageNo=" + this.pageNo + ", pageSize=" + this.pageSize + ")";
        }
    }
}

