/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.search.internal;

import java.io.IOException;
import java.util.Map;
import java.util.function.Function;
import org.easysearch.action.IndicesRequest;
import org.easysearch.action.OriginalIndices;
import org.easysearch.action.search.SearchRequest;
import org.easysearch.action.search.SearchShardTask;
import org.easysearch.action.search.SearchType;
import org.easysearch.action.support.IndicesOptions;
import org.easysearch.cluster.metadata.AliasMetadata;
import org.easysearch.cluster.metadata.IndexMetadata;
import org.easysearch.common.CheckedFunction;
import org.easysearch.common.Nullable;
import org.easysearch.common.Strings;
import org.easysearch.common.bytes.BytesReference;
import org.easysearch.common.collect.ImmutableOpenMap;
import org.easysearch.common.io.stream.BytesStreamOutput;
import org.easysearch.common.io.stream.StreamInput;
import org.easysearch.common.io.stream.StreamOutput;
import org.easysearch.common.unit.TimeValue;
import org.easysearch.index.Index;
import org.easysearch.index.query.BoolQueryBuilder;
import org.easysearch.index.query.MatchNoneQueryBuilder;
import org.easysearch.index.query.QueryBuilder;
import org.easysearch.index.query.QueryRewriteContext;
import org.easysearch.index.query.QueryShardContext;
import org.easysearch.index.query.Rewriteable;
import org.easysearch.index.shard.ShardId;
import org.easysearch.indices.AliasFilterParsingException;
import org.easysearch.indices.InvalidAliasNameException;
import org.easysearch.search.Scroll;
import org.easysearch.search.SearchSortValuesAndFormats;
import org.easysearch.search.builder.SearchSourceBuilder;
import org.easysearch.search.internal.AliasFilter;
import org.easysearch.search.internal.ShardSearchContextId;
import org.easysearch.search.sort.FieldSortBuilder;
import org.easysearch.tasks.Task;
import org.easysearch.tasks.TaskId;
import org.easysearch.transport.TransportRequest;

public class ShardSearchRequest
extends TransportRequest
implements IndicesRequest {
    private final String clusterAlias;
    private final ShardId shardId;
    private final int numberOfShards;
    private final SearchType searchType;
    private final Scroll scroll;
    private final String[] types;
    private final float indexBoost;
    private final Boolean requestCache;
    private final long nowInMillis;
    private final boolean allowPartialSearchResults;
    private final String[] indexRoutings;
    private final String preference;
    private final OriginalIndices originalIndices;
    private boolean canReturnNullResponseIfMatchNoDocs;
    private SearchSortValuesAndFormats bottomSortValues;
    private AliasFilter aliasFilter;
    private SearchSourceBuilder source;
    private final ShardSearchContextId readerId;
    private final TimeValue keepAlive;
    private static final ThreadLocal<BytesStreamOutput> scratch = ThreadLocal.withInitial(BytesStreamOutput::new);

    public ShardSearchRequest(OriginalIndices originalIndices, SearchRequest searchRequest, ShardId shardId, int numberOfShards, AliasFilter aliasFilter, float indexBoost, long nowInMillis, @Nullable String clusterAlias, String[] indexRoutings) {
        this(originalIndices, searchRequest, shardId, numberOfShards, aliasFilter, indexBoost, nowInMillis, clusterAlias, indexRoutings, null, null);
    }

    public ShardSearchRequest(OriginalIndices originalIndices, SearchRequest searchRequest, ShardId shardId, int numberOfShards, AliasFilter aliasFilter, float indexBoost, long nowInMillis, @Nullable String clusterAlias, String[] indexRoutings, ShardSearchContextId readerId, TimeValue keepAlive) {
        this(originalIndices, shardId, numberOfShards, searchRequest.searchType(), searchRequest.source(), searchRequest.types(), searchRequest.requestCache(), aliasFilter, indexBoost, searchRequest.allowPartialSearchResults(), indexRoutings, searchRequest.preference(), searchRequest.scroll(), nowInMillis, clusterAlias, readerId, keepAlive);
        assert (searchRequest.allowPartialSearchResults() != null);
    }

    public ShardSearchRequest(ShardId shardId, String[] types, long nowInMillis, AliasFilter aliasFilter) {
        this(OriginalIndices.NONE, shardId, -1, SearchType.QUERY_THEN_FETCH, null, types, null, aliasFilter, 1.0f, false, Strings.EMPTY_ARRAY, null, null, nowInMillis, null, null, null);
    }

    private ShardSearchRequest(OriginalIndices originalIndices, ShardId shardId, int numberOfShards, SearchType searchType, SearchSourceBuilder source, String[] types, Boolean requestCache, AliasFilter aliasFilter, float indexBoost, boolean allowPartialSearchResults, String[] indexRoutings, String preference, Scroll scroll, long nowInMillis, @Nullable String clusterAlias, ShardSearchContextId readerId, TimeValue keepAlive) {
        this.shardId = shardId;
        this.numberOfShards = numberOfShards;
        this.searchType = searchType;
        this.source = source;
        this.types = types;
        this.requestCache = requestCache;
        this.aliasFilter = aliasFilter;
        this.indexBoost = indexBoost;
        this.allowPartialSearchResults = allowPartialSearchResults;
        this.indexRoutings = indexRoutings;
        this.preference = preference;
        this.scroll = scroll;
        this.nowInMillis = nowInMillis;
        this.clusterAlias = clusterAlias;
        this.originalIndices = originalIndices;
        this.readerId = readerId;
        this.keepAlive = keepAlive;
        assert (keepAlive == null || readerId != null) : "readerId: " + readerId + " keepAlive: " + keepAlive;
    }

    public ShardSearchRequest(StreamInput in) throws IOException {
        super(in);
        this.shardId = new ShardId(in);
        this.searchType = SearchType.fromId(in.readByte());
        this.numberOfShards = in.readVInt();
        this.scroll = in.readOptionalWriteable(Scroll::new);
        this.source = in.readOptionalWriteable(SearchSourceBuilder::new);
        this.types = in.readStringArray();
        this.aliasFilter = new AliasFilter(in);
        this.indexBoost = in.readFloat();
        this.nowInMillis = in.readVLong();
        this.requestCache = in.readOptionalBoolean();
        this.clusterAlias = in.readOptionalString();
        this.allowPartialSearchResults = in.readBoolean();
        this.indexRoutings = in.readStringArray();
        this.preference = in.readOptionalString();
        this.canReturnNullResponseIfMatchNoDocs = in.readBoolean();
        this.bottomSortValues = in.readOptionalWriteable(SearchSortValuesAndFormats::new);
        this.readerId = in.readOptionalWriteable(ShardSearchContextId::new);
        this.keepAlive = in.readOptionalTimeValue();
        this.originalIndices = OriginalIndices.readOriginalIndices(in);
        assert (this.keepAlive == null || this.readerId != null) : "readerId: " + this.readerId + " keepAlive: " + this.keepAlive;
    }

    public ShardSearchRequest(ShardSearchRequest clone) {
        this.shardId = clone.shardId;
        this.searchType = clone.searchType;
        this.numberOfShards = clone.numberOfShards;
        this.scroll = clone.scroll;
        this.source = clone.source;
        this.types = clone.types;
        this.aliasFilter = clone.aliasFilter;
        this.indexBoost = clone.indexBoost;
        this.nowInMillis = clone.nowInMillis;
        this.requestCache = clone.requestCache;
        this.clusterAlias = clone.clusterAlias;
        this.allowPartialSearchResults = clone.allowPartialSearchResults;
        this.indexRoutings = clone.indexRoutings;
        this.preference = clone.preference;
        this.canReturnNullResponseIfMatchNoDocs = clone.canReturnNullResponseIfMatchNoDocs;
        this.bottomSortValues = clone.bottomSortValues;
        this.originalIndices = clone.originalIndices;
        this.readerId = clone.readerId;
        this.keepAlive = clone.keepAlive;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.innerWriteTo(out, false);
        OriginalIndices.writeOriginalIndices(this.originalIndices, out);
    }

    protected final void innerWriteTo(StreamOutput out, boolean asKey) throws IOException {
        this.shardId.writeTo(out);
        out.writeByte(this.searchType.id());
        if (!asKey) {
            out.writeVInt(this.numberOfShards);
        }
        out.writeOptionalWriteable(this.scroll);
        out.writeOptionalWriteable(this.source);
        out.writeStringArray(this.types);
        this.aliasFilter.writeTo(out);
        out.writeFloat(this.indexBoost);
        if (!asKey) {
            out.writeVLong(this.nowInMillis);
        }
        out.writeOptionalBoolean(this.requestCache);
        out.writeOptionalString(this.clusterAlias);
        out.writeBoolean(this.allowPartialSearchResults);
        if (!asKey) {
            out.writeStringArray(this.indexRoutings);
            out.writeOptionalString(this.preference);
        }
        out.writeBoolean(this.canReturnNullResponseIfMatchNoDocs);
        out.writeOptionalWriteable(this.bottomSortValues);
        if (!asKey) {
            out.writeOptionalWriteable(this.readerId);
            out.writeOptionalTimeValue(this.keepAlive);
        }
    }

    @Override
    public String[] indices() {
        if (this.originalIndices == null) {
            return null;
        }
        return this.originalIndices.indices();
    }

    @Override
    public IndicesOptions indicesOptions() {
        if (this.originalIndices == null) {
            return null;
        }
        return this.originalIndices.indicesOptions();
    }

    public ShardId shardId() {
        return this.shardId;
    }

    public String[] types() {
        return this.types;
    }

    public SearchSourceBuilder source() {
        return this.source;
    }

    public AliasFilter getAliasFilter() {
        return this.aliasFilter;
    }

    public void setAliasFilter(AliasFilter aliasFilter) {
        this.aliasFilter = aliasFilter;
    }

    public void source(SearchSourceBuilder source) {
        this.source = source;
    }

    public int numberOfShards() {
        return this.numberOfShards;
    }

    public SearchType searchType() {
        return this.searchType;
    }

    public float indexBoost() {
        return this.indexBoost;
    }

    public long nowInMillis() {
        return this.nowInMillis;
    }

    public Boolean requestCache() {
        return this.requestCache;
    }

    public boolean allowPartialSearchResults() {
        return this.allowPartialSearchResults;
    }

    public Scroll scroll() {
        return this.scroll;
    }

    public String[] indexRoutings() {
        return this.indexRoutings;
    }

    public String preference() {
        return this.preference;
    }

    public void setBottomSortValues(SearchSortValuesAndFormats values) {
        this.bottomSortValues = values;
    }

    public SearchSortValuesAndFormats getBottomSortValues() {
        return this.bottomSortValues;
    }

    public boolean canReturnNullResponseIfMatchNoDocs() {
        return this.canReturnNullResponseIfMatchNoDocs;
    }

    public void canReturnNullResponseIfMatchNoDocs(boolean value) {
        this.canReturnNullResponseIfMatchNoDocs = value;
    }

    public ShardSearchContextId readerId() {
        return this.readerId;
    }

    public TimeValue keepAlive() {
        return this.keepAlive;
    }

    public BytesReference cacheKey() throws IOException {
        BytesStreamOutput out = scratch.get();
        try {
            this.innerWriteTo(out, true);
            BytesReference bytesReference = out.copyBytes();
            return bytesReference;
        }
        finally {
            out.reset();
        }
    }

    public String getClusterAlias() {
        return this.clusterAlias;
    }

    @Override
    public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
        return new SearchShardTask(id, type, action, this.getDescription(), parentTaskId, headers);
    }

    @Override
    public String getDescription() {
        return "shardId[" + this.shardId() + "]";
    }

    public Rewriteable<Rewriteable> getRewriteable() {
        return new RequestRewritable(this);
    }

    public static QueryBuilder parseAliasFilter(CheckedFunction<BytesReference, QueryBuilder, IOException> filterParser, IndexMetadata metadata, String ... aliasNames) {
        if (aliasNames == null || aliasNames.length == 0) {
            return null;
        }
        Index index = metadata.getIndex();
        ImmutableOpenMap<String, AliasMetadata> aliases = metadata.getAliases();
        Function<AliasMetadata, QueryBuilder> parserFunction = alias -> {
            if (alias.filter() == null) {
                return null;
            }
            try {
                return (QueryBuilder)filterParser.apply(alias.filter().uncompressed());
            }
            catch (IOException ex) {
                throw new AliasFilterParsingException(index, alias.getAlias(), "Invalid alias filter", ex);
            }
        };
        if (aliasNames.length == 1) {
            AliasMetadata alias2 = aliases.get(aliasNames[0]);
            if (alias2 == null) {
                throw new InvalidAliasNameException(index, aliasNames[0], "Unknown alias name was passed to alias Filter");
            }
            return parserFunction.apply(alias2);
        }
        BoolQueryBuilder combined = new BoolQueryBuilder();
        for (String aliasName : aliasNames) {
            AliasMetadata alias3 = aliases.get(aliasName);
            if (alias3 == null) {
                throw new InvalidAliasNameException(index, aliasNames[0], "Unknown alias name was passed to alias Filter");
            }
            QueryBuilder parsedFilter = parserFunction.apply(alias3);
            if (parsedFilter == null) {
                return null;
            }
            combined.should(parsedFilter);
        }
        return combined;
    }

    static class RequestRewritable
    implements Rewriteable<Rewriteable> {
        final ShardSearchRequest request;

        RequestRewritable(ShardSearchRequest request) {
            this.request = request;
        }

        @Override
        public Rewriteable rewrite(QueryRewriteContext ctx) throws IOException {
            SearchSourceBuilder newSource = this.request.source() == null ? null : Rewriteable.rewrite(this.request.source(), ctx);
            AliasFilter newAliasFilter = Rewriteable.rewrite(this.request.getAliasFilter(), ctx);
            QueryShardContext shardContext = ctx.convertToShardContext();
            FieldSortBuilder primarySort = FieldSortBuilder.getPrimaryFieldSortOrNull(newSource);
            if (shardContext != null && primarySort != null && primarySort.isBottomSortShardDisjoint(shardContext, this.request.getBottomSortValues())) {
                assert (newSource != null) : "source should contain a primary sort field";
                newSource = newSource.shallowCopy();
                int trackTotalHitsUpTo = SearchRequest.resolveTrackTotalHitsUpTo(this.request.scroll, this.request.source);
                if (trackTotalHitsUpTo == -1 && newSource.suggest() == null && newSource.aggregations() == null) {
                    newSource.query(new MatchNoneQueryBuilder());
                } else {
                    newSource.size(0);
                }
                this.request.source(newSource);
                this.request.setBottomSortValues(null);
            }
            if (newSource == this.request.source() && newAliasFilter == this.request.getAliasFilter()) {
                return this;
            }
            this.request.source(newSource);
            this.request.setAliasFilter(newAliasFilter);
            return new RequestRewritable(this.request);
        }
    }
}

