/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.search.internal;

import java.io.IOException;
import java.util.Objects;
import org.easysearch.common.io.stream.StreamInput;
import org.easysearch.common.io.stream.StreamOutput;
import org.easysearch.common.io.stream.Writeable;

public final class ShardSearchContextId
implements Writeable {
    private final String sessionId;
    private final long id;

    public ShardSearchContextId(String sessionId, long id) {
        this.sessionId = Objects.requireNonNull(sessionId);
        this.id = id;
    }

    public ShardSearchContextId(StreamInput in) throws IOException {
        this.id = in.readLong();
        this.sessionId = in.readString();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeLong(this.id);
        out.writeString(this.sessionId);
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public long getId() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShardSearchContextId other = (ShardSearchContextId)o;
        return this.id == other.id && this.sessionId.equals(other.sessionId);
    }

    public int hashCode() {
        return Objects.hash(this.sessionId, this.id);
    }

    public String toString() {
        return "[" + this.sessionId + "][" + this.id + "]";
    }
}

