/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.search.fetch;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.ReaderUtil;
import org.easysearch.common.document.DocumentField;
import org.easysearch.search.SearchHit;
import org.easysearch.search.fetch.FetchContext;
import org.easysearch.search.fetch.FetchSubPhaseProcessor;
import org.easysearch.search.lookup.SourceLookup;

public interface FetchSubPhase {
    public FetchSubPhaseProcessor getProcessor(FetchContext var1) throws IOException;

    public static class HitContext {
        private final SearchHit hit;
        private final LeafReaderContext readerContext;
        private final int docId;
        private final SourceLookup sourceLookup;
        private final Map<String, DocumentField> reuseFields = new HashMap<String, DocumentField>();

        public HitContext(SearchHit hit, LeafReaderContext context, int docId, SourceLookup sourceLookup) {
            this.hit = hit;
            this.readerContext = context;
            this.docId = docId;
            this.sourceLookup = sourceLookup;
            sourceLookup.setSegmentAndDocument(context, docId);
        }

        public SearchHit hit() {
            return this.hit;
        }

        public LeafReader reader() {
            return this.readerContext.reader();
        }

        public LeafReaderContext readerContext() {
            return this.readerContext;
        }

        public int docId() {
            return this.docId;
        }

        public SourceLookup sourceLookup() {
            return this.sourceLookup;
        }

        public Map<String, DocumentField> getReuseFields() {
            return this.reuseFields;
        }

        public IndexReader topLevelReader() {
            return ReaderUtil.getTopLevelContext((IndexReaderContext)this.readerContext).reader();
        }
    }
}

