/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.search.aggregations.pipeline;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.easysearch.common.collect.EvictingQueue;
import org.easysearch.common.io.stream.StreamInput;
import org.easysearch.common.io.stream.StreamOutput;
import org.easysearch.search.DocValueFormat;
import org.easysearch.search.aggregations.InternalAggregation;
import org.easysearch.search.aggregations.InternalAggregations;
import org.easysearch.search.aggregations.InternalMultiBucketAggregation;
import org.easysearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.easysearch.search.aggregations.bucket.histogram.HistogramFactory;
import org.easysearch.search.aggregations.pipeline.BucketHelpers;
import org.easysearch.search.aggregations.pipeline.InternalSimpleValue;
import org.easysearch.search.aggregations.pipeline.MovAvgModel;
import org.easysearch.search.aggregations.pipeline.PipelineAggregator;
import org.easysearch.search.aggregations.pipeline.SimulatedAnealingMinimizer;

public class MovAvgPipelineAggregator
extends PipelineAggregator {
    private final DocValueFormat formatter;
    private final BucketHelpers.GapPolicy gapPolicy;
    private final int window;
    private MovAvgModel model;
    private final int predict;
    private final boolean minimize;

    MovAvgPipelineAggregator(String name, String[] bucketsPaths, DocValueFormat formatter, BucketHelpers.GapPolicy gapPolicy, int window, int predict, MovAvgModel model, boolean minimize, Map<String, Object> metadata) {
        super(name, bucketsPaths, metadata);
        this.formatter = formatter;
        this.gapPolicy = gapPolicy;
        this.window = window;
        this.model = model;
        this.predict = predict;
        this.minimize = minimize;
    }

    public MovAvgPipelineAggregator(StreamInput in) throws IOException {
        super(in);
        this.formatter = in.readNamedWriteable(DocValueFormat.class);
        this.gapPolicy = BucketHelpers.GapPolicy.readFrom(in);
        this.window = in.readVInt();
        this.predict = in.readVInt();
        this.model = in.readNamedWriteable(MovAvgModel.class);
        this.minimize = in.readBoolean();
    }

    @Override
    public void doWriteTo(StreamOutput out) throws IOException {
        out.writeNamedWriteable(this.formatter);
        this.gapPolicy.writeTo(out);
        out.writeVInt(this.window);
        out.writeVInt(this.predict);
        out.writeNamedWriteable(this.model);
        out.writeBoolean(this.minimize);
    }

    @Override
    public String getWriteableName() {
        return "moving_avg";
    }

    @Override
    public InternalAggregation reduce(InternalAggregation aggregation, InternalAggregation.ReduceContext reduceContext) {
        InternalMultiBucketAggregation histo = (InternalMultiBucketAggregation)aggregation;
        List buckets = histo.getBuckets();
        HistogramFactory factory = (HistogramFactory)((Object)histo);
        ArrayList<MultiBucketsAggregation.Bucket> newBuckets = new ArrayList<MultiBucketsAggregation.Bucket>();
        EvictingQueue<Double> values = new EvictingQueue<Double>(this.window);
        Number lastValidKey = 0;
        int lastValidPosition = 0;
        int counter = 0;
        if (this.minimize) {
            assert (this.model.canBeMinimized());
            this.model = this.minimize(buckets, histo, this.model);
        }
        for (InternalMultiBucketAggregation.InternalBucket bucket : buckets) {
            Double thisBucketValue = BucketHelpers.resolveBucketValue((MultiBucketsAggregation)histo, bucket, this.bucketsPaths()[0], this.gapPolicy);
            MultiBucketsAggregation.Bucket newBucket = bucket;
            if (!(thisBucketValue == null || thisBucketValue.equals(Double.NaN))) {
                if (this.model.hasValue(values.size())) {
                    double movavg = this.model.next(values);
                    List<InternalAggregation> aggs = StreamSupport.stream(bucket.getAggregations().spliterator(), false).map(p -> (InternalAggregation)p).collect(Collectors.toList());
                    aggs.add(new InternalSimpleValue(this.name(), movavg, this.formatter, this.metadata()));
                    newBucket = factory.createBucket(factory.getKey(bucket), bucket.getDocCount(), InternalAggregations.from(aggs));
                }
                if (this.predict > 0) {
                    lastValidKey = factory.getKey(bucket);
                    lastValidPosition = counter;
                }
                values.offer(thisBucketValue);
            }
            ++counter;
            newBuckets.add(newBucket);
        }
        if (buckets.size() > 0 && this.predict > 0) {
            double[] predictions = this.model.predict(values, this.predict);
            for (int i = 0; i < predictions.length; ++i) {
                ArrayList<InternalAggregation> aggs;
                Number newKey = factory.nextKey(lastValidKey);
                if (lastValidPosition + i + 1 < newBuckets.size()) {
                    MultiBucketsAggregation.Bucket bucket = (MultiBucketsAggregation.Bucket)newBuckets.get(lastValidPosition + i + 1);
                    aggs = StreamSupport.stream(bucket.getAggregations().spliterator(), false).map(p -> (InternalAggregation)p).collect(Collectors.toList());
                    aggs.add(new InternalSimpleValue(this.name(), predictions[i], this.formatter, this.metadata()));
                    MultiBucketsAggregation.Bucket newBucket = factory.createBucket(newKey, bucket.getDocCount(), InternalAggregations.from(aggs));
                    newBuckets.set(lastValidPosition + i + 1, newBucket);
                } else {
                    aggs = new ArrayList<InternalSimpleValue>();
                    aggs.add(new InternalSimpleValue(this.name(), predictions[i], this.formatter, this.metadata()));
                    MultiBucketsAggregation.Bucket newBucket = factory.createBucket(newKey, 0L, InternalAggregations.from(aggs));
                    newBuckets.add(newBucket);
                }
                lastValidKey = newKey;
            }
        }
        return factory.createAggregation(newBuckets);
    }

    private MovAvgModel minimize(List<? extends InternalMultiBucketAggregation.InternalBucket> buckets, MultiBucketsAggregation histo, MovAvgModel model) {
        int counter = 0;
        EvictingQueue<Double> values = new EvictingQueue<Double>(this.window);
        double[] test = new double[this.window];
        ListIterator<? extends InternalMultiBucketAggregation.InternalBucket> iter = buckets.listIterator(buckets.size());
        while (iter.hasPrevious() && counter < this.window) {
            Double thisBucketValue = BucketHelpers.resolveBucketValue(histo, iter.previous(), this.bucketsPaths()[0], this.gapPolicy);
            if (thisBucketValue == null || thisBucketValue.equals(Double.NaN)) continue;
            test[this.window - counter - 1] = thisBucketValue;
            ++counter;
        }
        if (counter < this.window) {
            return model;
        }
        counter = 0;
        double[] train = new double[this.window];
        while (iter.hasPrevious() && counter < this.window) {
            Double thisBucketValue = BucketHelpers.resolveBucketValue(histo, iter.previous(), this.bucketsPaths()[0], this.gapPolicy);
            if (thisBucketValue == null || thisBucketValue.equals(Double.NaN)) continue;
            train[this.window - counter - 1] = thisBucketValue;
            ++counter;
        }
        if (counter < this.window) {
            return model;
        }
        for (double v : train) {
            values.add(v);
        }
        return SimulatedAnealingMinimizer.minimize(model, values, test);
    }
}

