/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.Map;
import org.easysearch.search.DocValueFormat;
import org.easysearch.search.aggregations.Aggregator;
import org.easysearch.search.aggregations.InternalAggregation;
import org.easysearch.search.aggregations.metrics.AbstractTDigestPercentilesAggregator;
import org.easysearch.search.aggregations.metrics.InternalTDigestPercentileRanks;
import org.easysearch.search.aggregations.metrics.TDigestState;
import org.easysearch.search.aggregations.support.ValuesSource;
import org.easysearch.search.internal.SearchContext;

class TDigestPercentileRanksAggregator
extends AbstractTDigestPercentilesAggregator {
    TDigestPercentileRanksAggregator(String name, ValuesSource valuesSource, SearchContext context, Aggregator parent, double[] percents, double compression, boolean keyed, DocValueFormat formatter, Map<String, Object> metadata) throws IOException {
        super(name, valuesSource, context, parent, percents, compression, keyed, formatter, metadata);
    }

    @Override
    public InternalAggregation buildAggregation(long owningBucketOrdinal) {
        TDigestState state = this.getState(owningBucketOrdinal);
        if (state == null) {
            return this.buildEmptyAggregation();
        }
        return new InternalTDigestPercentileRanks(this.name, this.keys, state, this.keyed, this.formatter, this.metadata());
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return new InternalTDigestPercentileRanks(this.name, this.keys, new TDigestState(this.compression), this.keyed, this.formatter, this.metadata());
    }

    @Override
    public double metric(String name, long bucketOrd) {
        TDigestState state = this.getState(bucketOrd);
        if (state == null) {
            return Double.NaN;
        }
        return InternalTDigestPercentileRanks.percentileRank(state, Double.valueOf(name));
    }
}

