/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.Map;
import org.easysearch.index.query.QueryShardContext;
import org.easysearch.search.aggregations.Aggregator;
import org.easysearch.search.aggregations.AggregatorFactories;
import org.easysearch.search.aggregations.AggregatorFactory;
import org.easysearch.search.aggregations.CardinalityUpperBound;
import org.easysearch.search.aggregations.metrics.GeoBoundsAggregationBuilder;
import org.easysearch.search.aggregations.metrics.GeoBoundsAggregator;
import org.easysearch.search.aggregations.support.CoreValuesSourceType;
import org.easysearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.easysearch.search.aggregations.support.ValuesSourceConfig;
import org.easysearch.search.aggregations.support.ValuesSourceRegistry;
import org.easysearch.search.internal.SearchContext;

class GeoBoundsAggregatorFactory
extends ValuesSourceAggregatorFactory {
    private final boolean wrapLongitude;

    GeoBoundsAggregatorFactory(String name, ValuesSourceConfig config, boolean wrapLongitude, QueryShardContext queryShardContext, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metadata) throws IOException {
        super(name, config, queryShardContext, parent, subFactoriesBuilder, metadata);
        this.wrapLongitude = wrapLongitude;
    }

    @Override
    protected Aggregator createUnmapped(SearchContext searchContext, Aggregator parent, Map<String, Object> metadata) throws IOException {
        return new GeoBoundsAggregator(this.name, searchContext, parent, this.config, this.wrapLongitude, metadata);
    }

    @Override
    protected Aggregator doCreateInternal(SearchContext searchContext, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        return this.queryShardContext.getValuesSourceRegistry().getAggregator(GeoBoundsAggregationBuilder.REGISTRY_KEY, this.config).build(this.name, searchContext, parent, this.config, this.wrapLongitude, metadata);
    }

    static void registerAggregators(ValuesSourceRegistry.Builder builder) {
        builder.register(GeoBoundsAggregationBuilder.REGISTRY_KEY, CoreValuesSourceType.GEOPOINT, GeoBoundsAggregator::new, true);
    }
}

