/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import org.easysearch.index.query.QueryShardContext;
import org.easysearch.search.aggregations.Aggregator;
import org.easysearch.search.aggregations.AggregatorFactories;
import org.easysearch.search.aggregations.AggregatorFactory;
import org.easysearch.search.aggregations.CardinalityUpperBound;
import org.easysearch.search.aggregations.metrics.ExtendedStatsAggregationBuilder;
import org.easysearch.search.aggregations.metrics.ExtendedStatsAggregator;
import org.easysearch.search.aggregations.support.CoreValuesSourceType;
import org.easysearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.easysearch.search.aggregations.support.ValuesSourceConfig;
import org.easysearch.search.aggregations.support.ValuesSourceRegistry;
import org.easysearch.search.internal.SearchContext;

class ExtendedStatsAggregatorFactory
extends ValuesSourceAggregatorFactory {
    private final double sigma;

    ExtendedStatsAggregatorFactory(String name, ValuesSourceConfig config, double sigma, QueryShardContext queryShardContext, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metadata) throws IOException {
        super(name, config, queryShardContext, parent, subFactoriesBuilder, metadata);
        this.sigma = sigma;
    }

    static void registerAggregators(ValuesSourceRegistry.Builder builder) {
        builder.register(ExtendedStatsAggregationBuilder.REGISTRY_KEY, Arrays.asList(CoreValuesSourceType.NUMERIC, CoreValuesSourceType.DATE, CoreValuesSourceType.BOOLEAN), ExtendedStatsAggregator::new, true);
    }

    @Override
    protected Aggregator createUnmapped(SearchContext searchContext, Aggregator parent, Map<String, Object> metadata) throws IOException {
        return new ExtendedStatsAggregator(this.name, this.config, searchContext, parent, this.sigma, metadata);
    }

    @Override
    protected Aggregator doCreateInternal(SearchContext searchContext, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        return this.queryShardContext.getValuesSourceRegistry().getAggregator(ExtendedStatsAggregationBuilder.REGISTRY_KEY, this.config).build(this.name, this.config, searchContext, parent, this.sigma, metadata);
    }
}

