/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.search.aggregations.bucket.terms;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.easysearch.common.io.stream.StreamInput;
import org.easysearch.common.io.stream.StreamOutput;
import org.easysearch.common.util.SetBackedScalingCuckooFilter;
import org.easysearch.common.xcontent.ToXContent;
import org.easysearch.common.xcontent.XContentBuilder;
import org.easysearch.search.DocValueFormat;
import org.easysearch.search.aggregations.Aggregation;
import org.easysearch.search.aggregations.Aggregations;
import org.easysearch.search.aggregations.BucketOrder;
import org.easysearch.search.aggregations.InternalAggregation;
import org.easysearch.search.aggregations.InternalAggregations;
import org.easysearch.search.aggregations.InternalMultiBucketAggregation;
import org.easysearch.search.aggregations.InternalOrder;
import org.easysearch.search.aggregations.KeyComparable;
import org.easysearch.search.aggregations.bucket.terms.RareTerms;

public abstract class InternalRareTerms<A extends InternalRareTerms<A, B>, B extends Bucket<B>>
extends InternalMultiBucketAggregation<A, B>
implements RareTerms {
    protected final BucketOrder order;
    protected final long maxDocCount;

    protected InternalRareTerms(String name, BucketOrder order, long maxDocCount, Map<String, Object> metadata) {
        super(name, metadata);
        this.order = order;
        this.maxDocCount = maxDocCount;
    }

    protected InternalRareTerms(StreamInput in) throws IOException {
        super(in);
        this.order = InternalOrder.Streams.readOrder(in);
        this.maxDocCount = in.readVLong();
    }

    @Override
    protected final void doWriteTo(StreamOutput out) throws IOException {
        this.order.writeTo(out);
        out.writeVLong(this.maxDocCount);
        this.writeTermTypeInfoTo(out);
    }

    protected abstract void writeTermTypeInfoTo(StreamOutput var1) throws IOException;

    @Override
    public abstract List<B> getBuckets();

    public abstract B getBucketByKey(String var1);

    @Override
    public InternalAggregation reduce(List<InternalAggregation> aggregations, InternalAggregation.ReduceContext reduceContext) {
        throw new UnsupportedOperationException();
    }

    abstract B createBucket(long var1, InternalAggregations var3, B var4);

    @Override
    protected B reduceBucket(List<B> buckets, InternalAggregation.ReduceContext context) {
        assert (buckets.size() > 0);
        long docCount = 0L;
        ArrayList<InternalAggregations> aggregationsList = new ArrayList<InternalAggregations>(buckets.size());
        for (Bucket bucket : buckets) {
            docCount += bucket.docCount;
            aggregationsList.add(bucket.aggregations);
        }
        InternalAggregations aggs = InternalAggregations.reduce(aggregationsList, context);
        return (B)this.createBucket(docCount, aggs, (Bucket)buckets.get(0));
    }

    protected abstract A createWithFilter(String var1, List<B> var2, SetBackedScalingCuckooFilter var3);

    protected abstract B[] createBucketsArray(int var1);

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        InternalRareTerms that = (InternalRareTerms)obj;
        return Objects.equals(this.maxDocCount, that.maxDocCount) && Objects.equals(this.order, that.order);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.maxDocCount, this.order);
    }

    protected static XContentBuilder doXContentCommon(XContentBuilder builder, ToXContent.Params params, List<? extends Bucket> buckets) throws IOException {
        builder.startArray(Aggregation.CommonFields.BUCKETS.getPreferredName());
        for (Bucket bucket : buckets) {
            bucket.toXContent(builder, params);
        }
        builder.endArray();
        return builder;
    }

    public static abstract class Bucket<B extends Bucket<B>>
    extends InternalMultiBucketAggregation.InternalBucket
    implements RareTerms.Bucket,
    KeyComparable<B> {
        long bucketOrd;
        protected long docCount;
        protected InternalAggregations aggregations;
        protected final DocValueFormat format;

        protected Bucket(long docCount, InternalAggregations aggregations, DocValueFormat formatter) {
            this.format = formatter;
            this.docCount = docCount;
            this.aggregations = aggregations;
        }

        protected Bucket(StreamInput in, DocValueFormat formatter) throws IOException {
            this.format = formatter;
            this.docCount = in.readVLong();
            this.aggregations = InternalAggregations.readFrom(in);
        }

        @Override
        public final void writeTo(StreamOutput out) throws IOException {
            out.writeVLong(this.getDocCount());
            this.aggregations.writeTo(out);
            this.writeTermTo(out);
        }

        protected abstract void writeTermTo(StreamOutput var1) throws IOException;

        @Override
        public long getDocCount() {
            return this.docCount;
        }

        @Override
        public Aggregations getAggregations() {
            return this.aggregations;
        }

        @Override
        public final XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            this.keyToXContent(builder);
            builder.field(Aggregation.CommonFields.DOC_COUNT.getPreferredName(), this.getDocCount());
            this.aggregations.toXContentInternal(builder, params);
            builder.endObject();
            return builder;
        }

        protected abstract XContentBuilder keyToXContent(XContentBuilder var1) throws IOException;

        public boolean equals(Object obj) {
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Bucket that = (Bucket)obj;
            return Objects.equals(this.docCount, that.docCount) && Objects.equals(this.aggregations, that.aggregations);
        }

        public int hashCode() {
            return Objects.hash(this.getClass(), this.docCount, this.aggregations);
        }

        @FunctionalInterface
        public static interface Reader<B extends Bucket<B>> {
            public B read(StreamInput var1, DocValueFormat var2) throws IOException;
        }
    }
}

