/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.script.mustache;

import java.util.ArrayList;
import org.easysearch.action.ActionListener;
import org.easysearch.action.search.MultiSearchRequest;
import org.easysearch.action.search.MultiSearchResponse;
import org.easysearch.action.search.SearchRequest;
import org.easysearch.action.support.ActionFilters;
import org.easysearch.action.support.HandledTransportAction;
import org.easysearch.client.node.NodeClient;
import org.easysearch.common.inject.Inject;
import org.easysearch.common.xcontent.NamedXContentRegistry;
import org.easysearch.script.ScriptService;
import org.easysearch.script.mustache.MultiSearchTemplateRequest;
import org.easysearch.script.mustache.MultiSearchTemplateResponse;
import org.easysearch.script.mustache.SearchTemplateRequest;
import org.easysearch.script.mustache.SearchTemplateResponse;
import org.easysearch.script.mustache.TransportSearchTemplateAction;
import org.easysearch.tasks.Task;
import org.easysearch.transport.TransportService;

public class TransportMultiSearchTemplateAction
extends HandledTransportAction<MultiSearchTemplateRequest, MultiSearchTemplateResponse> {
    private final ScriptService scriptService;
    private final NamedXContentRegistry xContentRegistry;
    private final NodeClient client;

    @Inject
    public TransportMultiSearchTemplateAction(TransportService transportService, ActionFilters actionFilters, ScriptService scriptService, NamedXContentRegistry xContentRegistry, NodeClient client) {
        super("indices:data/read/msearch/template", transportService, actionFilters, MultiSearchTemplateRequest::new);
        this.scriptService = scriptService;
        this.xContentRegistry = xContentRegistry;
        this.client = client;
    }

    @Override
    protected void doExecute(Task task, MultiSearchTemplateRequest request, ActionListener<MultiSearchTemplateResponse> listener) {
        ArrayList<Integer> originalSlots = new ArrayList<Integer>();
        MultiSearchRequest multiSearchRequest = new MultiSearchRequest();
        multiSearchRequest.indicesOptions(request.indicesOptions());
        if (request.maxConcurrentSearchRequests() != 0) {
            multiSearchRequest.maxConcurrentSearchRequests(request.maxConcurrentSearchRequests());
        }
        MultiSearchTemplateResponse.Item[] items = new MultiSearchTemplateResponse.Item[request.requests().size()];
        for (int i = 0; i < items.length; ++i) {
            SearchRequest searchRequest;
            SearchTemplateRequest searchTemplateRequest = request.requests().get(i);
            SearchTemplateResponse searchTemplateResponse = new SearchTemplateResponse();
            try {
                searchRequest = TransportSearchTemplateAction.convert(searchTemplateRequest, searchTemplateResponse, this.scriptService, this.xContentRegistry);
            }
            catch (Exception e) {
                items[i] = new MultiSearchTemplateResponse.Item(null, e);
                continue;
            }
            items[i] = new MultiSearchTemplateResponse.Item(searchTemplateResponse, null);
            if (searchRequest == null) continue;
            multiSearchRequest.add(searchRequest);
            originalSlots.add(i);
        }
        this.client.multiSearch(multiSearchRequest, ActionListener.wrap(r -> {
            for (int i = 0; i < r.getResponses().length; ++i) {
                MultiSearchResponse.Item item = r.getResponses()[i];
                int originalSlot = (Integer)originalSlots.get(i);
                if (item.isFailure()) {
                    items[originalSlot] = new MultiSearchTemplateResponse.Item(null, item.getFailure());
                    continue;
                }
                items[originalSlot].getResponse().setResponse(item.getResponse());
            }
            listener.onResponse(new MultiSearchTemplateResponse(items, r.getTook().millis()));
        }, listener::onFailure));
    }
}

