/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.script;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.easysearch.common.settings.ClusterSettings;
import org.easysearch.common.settings.Settings;
import org.easysearch.index.query.IntervalFilterScript;
import org.easysearch.plugins.ScriptPlugin;
import org.easysearch.script.AggregationScript;
import org.easysearch.script.BucketAggregationScript;
import org.easysearch.script.BucketAggregationSelectorScript;
import org.easysearch.script.FieldScript;
import org.easysearch.script.FilterScript;
import org.easysearch.script.IngestConditionalScript;
import org.easysearch.script.IngestScript;
import org.easysearch.script.NumberSortScript;
import org.easysearch.script.ScoreScript;
import org.easysearch.script.ScriptContext;
import org.easysearch.script.ScriptEngine;
import org.easysearch.script.ScriptService;
import org.easysearch.script.ScriptedMetricAggContexts;
import org.easysearch.script.SignificantTermsHeuristicScoreScript;
import org.easysearch.script.SimilarityScript;
import org.easysearch.script.SimilarityWeightScript;
import org.easysearch.script.StringSortScript;
import org.easysearch.script.TemplateScript;
import org.easysearch.script.TermsSetQueryScript;
import org.easysearch.script.UpdateScript;
import org.easysearch.search.aggregations.pipeline.MovingFunctionScript;

public class ScriptModule {
    public static final Map<String, ScriptContext<?>> CORE_CONTEXTS = Stream.of(FieldScript.CONTEXT, AggregationScript.CONTEXT, ScoreScript.CONTEXT, NumberSortScript.CONTEXT, StringSortScript.CONTEXT, TermsSetQueryScript.CONTEXT, UpdateScript.CONTEXT, BucketAggregationScript.CONTEXT, BucketAggregationSelectorScript.CONTEXT, SignificantTermsHeuristicScoreScript.CONTEXT, IngestScript.CONTEXT, IngestConditionalScript.CONTEXT, FilterScript.CONTEXT, SimilarityScript.CONTEXT, SimilarityWeightScript.CONTEXT, TemplateScript.CONTEXT, MovingFunctionScript.CONTEXT, ScriptedMetricAggContexts.InitScript.CONTEXT, ScriptedMetricAggContexts.MapScript.CONTEXT, ScriptedMetricAggContexts.CombineScript.CONTEXT, ScriptedMetricAggContexts.ReduceScript.CONTEXT, IntervalFilterScript.CONTEXT).collect(Collectors.toMap(c -> c.name, Function.identity()));
    public final Map<String, ScriptEngine> engines;
    public final Map<String, ScriptContext<?>> contexts;

    public ScriptModule(Settings settings, List<ScriptPlugin> scriptPlugins) {
        HashMap<String, ScriptEngine> engines = new HashMap<String, ScriptEngine>();
        HashMap contexts = new HashMap(CORE_CONTEXTS);
        for (ScriptPlugin plugin : scriptPlugins) {
            for (ScriptContext<?> context : plugin.getContexts()) {
                ScriptContext<?> oldContext = contexts.put(context.name, context);
                if (oldContext == null) continue;
                throw new IllegalArgumentException("Context name [" + context.name + "] defined twice");
            }
        }
        for (ScriptPlugin plugin : scriptPlugins) {
            ScriptEngine existing;
            ScriptEngine engine = plugin.getScriptEngine(settings, contexts.values());
            if (engine == null || (existing = engines.put(engine.getType(), engine)) == null) continue;
            throw new IllegalArgumentException("scripting language [" + engine.getType() + "] defined for engine [" + existing.getClass().getName() + "] and [" + engine.getClass().getName());
        }
        this.engines = Collections.unmodifiableMap(engines);
        this.contexts = Collections.unmodifiableMap(contexts);
    }

    public void registerClusterSettingsListeners(ScriptService scriptService, ClusterSettings clusterSettings) {
        scriptService.registerClusterSettingsListeners(clusterSettings);
    }
}

