/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.rest.action.search;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.easysearch.action.search.SearchResponse;
import org.easysearch.action.search.SearchScrollRequest;
import org.easysearch.client.node.NodeClient;
import org.easysearch.common.unit.TimeValue;
import org.easysearch.common.xcontent.XContentParser;
import org.easysearch.rest.BaseRestHandler;
import org.easysearch.rest.RestChannel;
import org.easysearch.rest.RestHandler;
import org.easysearch.rest.RestRequest;
import org.easysearch.rest.action.RestStatusToXContentListener;
import org.easysearch.search.Scroll;

public class RestSearchScrollAction
extends BaseRestHandler {
    private static final Set<String> RESPONSE_PARAMS = Collections.singleton("rest_total_hits_as_int");

    @Override
    public String getName() {
        return "search_scroll_action";
    }

    @Override
    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.GET, "/_search/scroll"), new RestHandler.Route(RestRequest.Method.POST, "/_search/scroll"), new RestHandler.Route(RestRequest.Method.GET, "/_search/scroll/{scroll_id}"), new RestHandler.Route(RestRequest.Method.POST, "/_search/scroll/{scroll_id}")));
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String scrollId = request.param("scroll_id");
        SearchScrollRequest searchScrollRequest = new SearchScrollRequest();
        searchScrollRequest.scrollId(scrollId);
        String scroll = request.param("scroll");
        if (scroll != null) {
            searchScrollRequest.scroll(new Scroll(TimeValue.parseTimeValue(scroll, null, "scroll")));
        }
        request.withContentOrSourceParamParserOrNull(xContentParser -> {
            if (xContentParser != null) {
                try {
                    searchScrollRequest.fromXContent((XContentParser)xContentParser);
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Failed to parse request body", e);
                }
            }
        });
        return channel -> client.searchScroll(searchScrollRequest, new RestStatusToXContentListener<SearchResponse>((RestChannel)channel));
    }

    @Override
    protected Set<String> responseParams() {
        return RESPONSE_PARAMS;
    }
}

