/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.rest.action.document;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.easysearch.ResourceNotFoundException;
import org.easysearch.action.ActionRequestValidationException;
import org.easysearch.action.get.GetRequest;
import org.easysearch.action.get.GetResponse;
import org.easysearch.client.node.NodeClient;
import org.easysearch.common.bytes.BytesReference;
import org.easysearch.common.io.stream.StreamInput;
import org.easysearch.common.logging.DeprecationLogger;
import org.easysearch.common.xcontent.XContentBuilder;
import org.easysearch.common.xcontent.XContentHelper;
import org.easysearch.rest.BaseRestHandler;
import org.easysearch.rest.BytesRestResponse;
import org.easysearch.rest.RestChannel;
import org.easysearch.rest.RestHandler;
import org.easysearch.rest.RestRequest;
import org.easysearch.rest.RestResponse;
import org.easysearch.rest.RestStatus;
import org.easysearch.rest.action.RestResponseListener;
import org.easysearch.search.fetch.subphase.FetchSourceContext;

public class RestGetSourceAction
extends BaseRestHandler {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(RestGetSourceAction.class);
    static final String TYPES_DEPRECATION_MESSAGE = "[types removal] Specifying types in get_source and exist_sourcerequests is deprecated.";

    @Override
    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.GET, "/{index}/_source/{id}"), new RestHandler.Route(RestRequest.Method.HEAD, "/{index}/_source/{id}"), new RestHandler.Route(RestRequest.Method.GET, "/{index}/{type}/{id}/_source"), new RestHandler.Route(RestRequest.Method.HEAD, "/{index}/{type}/{id}/_source")));
    }

    @Override
    public String getName() {
        return "document_get_source_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        GetRequest getRequest;
        if (request.hasParam("type")) {
            deprecationLogger.deprecate("get_source_with_types", TYPES_DEPRECATION_MESSAGE, new Object[0]);
            getRequest = new GetRequest(request.param("index"), request.param("type"), request.param("id"));
        } else {
            getRequest = new GetRequest(request.param("index"), request.param("id"));
        }
        getRequest.refresh(request.paramAsBoolean("refresh", getRequest.refresh()));
        getRequest.routing(request.param("routing"));
        getRequest.preference(request.param("preference"));
        getRequest.realtime(request.paramAsBoolean("realtime", getRequest.realtime()));
        getRequest.fetchSourceContext(FetchSourceContext.parseFromRestRequest(request));
        return channel -> {
            if (getRequest.fetchSourceContext() != null && !getRequest.fetchSourceContext().fetchSource()) {
                ActionRequestValidationException validationError = new ActionRequestValidationException();
                validationError.addValidationError("fetching source can not be disabled");
                channel.sendResponse(new BytesRestResponse((RestChannel)channel, validationError));
            } else {
                client.get(getRequest, new RestGetSourceResponseListener((RestChannel)channel, request));
            }
        };
    }

    static class RestGetSourceResponseListener
    extends RestResponseListener<GetResponse> {
        private final RestRequest request;

        RestGetSourceResponseListener(RestChannel channel, RestRequest request) {
            super(channel);
            this.request = request;
        }

        @Override
        public RestResponse buildResponse(GetResponse response) throws Exception {
            this.checkResource(response);
            XContentBuilder builder = this.channel.newBuilder(this.request.getXContentType(), false);
            BytesReference source = response.getSourceInternal();
            try (StreamInput stream = source.streamInput();){
                builder.rawValue(stream, XContentHelper.xContentType(source));
            }
            return new BytesRestResponse(RestStatus.OK, builder);
        }

        private void checkResource(GetResponse response) {
            String index = response.getIndex();
            String type = response.getType();
            String id = response.getId();
            if (!response.isExists()) {
                throw new ResourceNotFoundException("Document not found [" + index + "]/[" + type + "]/[" + id + "]", new Object[0]);
            }
            if (response.isSourceEmpty()) {
                throw new ResourceNotFoundException("Source not found [" + index + "]/[" + type + "]/[" + id + "]", new Object[0]);
            }
        }
    }
}

