/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.rest.action.admin.indices;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.easysearch.action.admin.indices.template.put.PutIndexTemplateRequest;
import org.easysearch.action.support.master.AcknowledgedResponse;
import org.easysearch.client.node.NodeClient;
import org.easysearch.common.Strings;
import org.easysearch.common.logging.DeprecationLogger;
import org.easysearch.common.xcontent.XContentHelper;
import org.easysearch.rest.BaseRestHandler;
import org.easysearch.rest.RestChannel;
import org.easysearch.rest.RestHandler;
import org.easysearch.rest.RestRequest;
import org.easysearch.rest.action.RestToXContentListener;
import org.easysearch.rest.action.admin.indices.RestCreateIndexAction;

public class RestPutIndexTemplateAction
extends BaseRestHandler {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(RestPutIndexTemplateAction.class);
    public static final String TYPES_DEPRECATION_MESSAGE = "[types removal] Specifying include_type_name in put index template requests is deprecated. The parameter will be removed in the next major version.";

    @Override
    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.POST, "/_template/{name}"), new RestHandler.Route(RestRequest.Method.PUT, "/_template/{name}")));
    }

    @Override
    public String getName() {
        return "put_index_template_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        boolean includeTypeName = request.paramAsBoolean("include_type_name", false);
        PutIndexTemplateRequest putRequest = new PutIndexTemplateRequest(request.param("name"));
        if (request.hasParam("include_type_name")) {
            deprecationLogger.deprecate("put_index_template_with_types", TYPES_DEPRECATION_MESSAGE, new Object[0]);
        }
        if (request.hasParam("template")) {
            deprecationLogger.deprecate("put_index_template_deprecated_parameter", "Deprecated parameter [template] used, replaced by [index_patterns]", new Object[0]);
            putRequest.patterns(Collections.singletonList(request.param("template")));
        } else {
            putRequest.patterns(Arrays.asList(request.paramAsStringArray("index_patterns", Strings.EMPTY_ARRAY)));
        }
        putRequest.order(request.paramAsInt("order", putRequest.order()));
        putRequest.masterNodeTimeout(request.paramAsTime("master_timeout", putRequest.masterNodeTimeout()));
        putRequest.create(request.paramAsBoolean("create", false));
        putRequest.cause(request.param("cause", ""));
        Map<String, Object> sourceAsMap = XContentHelper.convertToMap(request.requiredContent(), false, request.getXContentType()).v2();
        sourceAsMap = RestCreateIndexAction.prepareMappings(sourceAsMap, includeTypeName);
        putRequest.source(sourceAsMap);
        return channel -> client.admin().indices().putTemplate(putRequest, new RestToXContentListener<AcknowledgedResponse>((RestChannel)channel));
    }
}

