/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.rest.action.admin.indices;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.easysearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.easysearch.action.support.master.AcknowledgedResponse;
import org.easysearch.client.node.NodeClient;
import org.easysearch.common.Strings;
import org.easysearch.rest.BaseRestHandler;
import org.easysearch.rest.RestChannel;
import org.easysearch.rest.RestHandler;
import org.easysearch.rest.RestRequest;
import org.easysearch.rest.action.RestToXContentListener;

public class RestIndexDeleteAliasesAction
extends BaseRestHandler {
    @Override
    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.DELETE, "/{index}/_alias/{name}"), new RestHandler.Route(RestRequest.Method.DELETE, "/{index}/_aliases/{name}")));
    }

    @Override
    public String getName() {
        return "index_delete_aliases_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String[] indices = Strings.splitStringByCommaToArray(request.param("index"));
        String[] aliases = Strings.splitStringByCommaToArray(request.param("name"));
        IndicesAliasesRequest indicesAliasesRequest = new IndicesAliasesRequest();
        indicesAliasesRequest.timeout(request.paramAsTime("timeout", indicesAliasesRequest.timeout()));
        indicesAliasesRequest.addAliasAction(IndicesAliasesRequest.AliasActions.remove().indices(indices).aliases(aliases));
        indicesAliasesRequest.masterNodeTimeout(request.paramAsTime("master_timeout", indicesAliasesRequest.masterNodeTimeout()));
        return channel -> client.admin().indices().aliases(indicesAliasesRequest, new RestToXContentListener<AcknowledgedResponse>((RestChannel)channel));
    }
}

