/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.rest.action.admin.indices;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.easysearch.action.admin.indices.datastream.DataStreamsStatsAction;
import org.easysearch.action.support.IndicesOptions;
import org.easysearch.client.node.NodeClient;
import org.easysearch.common.Strings;
import org.easysearch.rest.BaseRestHandler;
import org.easysearch.rest.RestChannel;
import org.easysearch.rest.RestHandler;
import org.easysearch.rest.RestRequest;
import org.easysearch.rest.action.RestToXContentListener;

public class RestDataStreamsStatsAction
extends BaseRestHandler {
    @Override
    public String getName() {
        return "data_stream_stats_action";
    }

    @Override
    public List<RestHandler.Route> routes() {
        return Arrays.asList(new RestHandler.Route(RestRequest.Method.GET, "/_data_stream/_stats"), new RestHandler.Route(RestRequest.Method.GET, "/_data_stream/{name}/_stats"));
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        IndicesOptions defaultIndicesOption;
        DataStreamsStatsAction.Request dataStreamsStatsRequest = new DataStreamsStatsAction.Request();
        boolean forbidClosedIndices = request.paramAsBoolean("forbid_closed_indices", true);
        IndicesOptions indicesOptions = defaultIndicesOption = forbidClosedIndices ? dataStreamsStatsRequest.indicesOptions() : IndicesOptions.strictExpandOpen();
        assert (dataStreamsStatsRequest.indicesOptions() == IndicesOptions.strictExpandOpenAndForbidClosed()) : "DataStreamStats default indices options changed";
        dataStreamsStatsRequest.indicesOptions(IndicesOptions.fromRequest(request, defaultIndicesOption));
        dataStreamsStatsRequest.indices(Strings.splitStringByCommaToArray(request.param("name")));
        return channel -> client.execute(DataStreamsStatsAction.INSTANCE, dataStreamsStatsRequest, new RestToXContentListener((RestChannel)channel));
    }
}

