/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.rest.action.admin.cluster;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.easysearch.action.admin.cluster.repositories.put.PutRepositoryRequest;
import org.easysearch.action.support.master.AcknowledgedResponse;
import org.easysearch.client.Requests;
import org.easysearch.client.node.NodeClient;
import org.easysearch.common.xcontent.XContentParser;
import org.easysearch.rest.BaseRestHandler;
import org.easysearch.rest.RestChannel;
import org.easysearch.rest.RestHandler;
import org.easysearch.rest.RestRequest;
import org.easysearch.rest.action.RestToXContentListener;

public class RestPutRepositoryAction
extends BaseRestHandler {
    @Override
    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.POST, "/_snapshot/{repository}"), new RestHandler.Route(RestRequest.Method.PUT, "/_snapshot/{repository}")));
    }

    @Override
    public String getName() {
        return "put_repository_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        PutRepositoryRequest putRepositoryRequest = Requests.putRepositoryRequest(request.param("repository"));
        try (XContentParser parser = request.contentParser();){
            putRepositoryRequest.source(parser.mapOrdered());
        }
        putRepositoryRequest.verify(request.paramAsBoolean("verify", true));
        putRepositoryRequest.masterNodeTimeout(request.paramAsTime("master_timeout", putRepositoryRequest.masterNodeTimeout()));
        putRepositoryRequest.timeout(request.paramAsTime("timeout", putRepositoryRequest.timeout()));
        return channel -> client.admin().cluster().putRepository(putRepositoryRequest, new RestToXContentListener<AcknowledgedResponse>((RestChannel)channel));
    }
}

