/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.rest.action;

import java.util.function.Function;
import org.easysearch.common.xcontent.StatusToXContentObject;
import org.easysearch.common.xcontent.XContentBuilder;
import org.easysearch.rest.BytesRestResponse;
import org.easysearch.rest.RestChannel;
import org.easysearch.rest.RestResponse;
import org.easysearch.rest.RestStatus;
import org.easysearch.rest.action.RestToXContentListener;

public class RestStatusToXContentListener<Response extends StatusToXContentObject>
extends RestToXContentListener<Response> {
    private final Function<Response, String> extractLocation;

    public RestStatusToXContentListener(RestChannel channel) {
        this(channel, r -> {
            assert (false) : "Returned a 201 CREATED but not set up to support a Location header";
            return null;
        });
    }

    public RestStatusToXContentListener(RestChannel channel, Function<Response, String> extractLocation) {
        super(channel);
        this.extractLocation = extractLocation;
    }

    @Override
    public RestResponse buildResponse(Response response, XContentBuilder builder) throws Exception {
        String location;
        assert (!response.isFragment());
        response.toXContent(builder, this.channel.request());
        BytesRestResponse restResponse = new BytesRestResponse(response.status(), builder);
        if (RestStatus.CREATED == ((RestResponse)restResponse).status() && (location = this.extractLocation.apply(response)) != null) {
            restResponse.addHeader("Location", location);
        }
        return restResponse;
    }
}

