/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.plugins;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.NoSuchAlgorithmException;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.URIParameter;
import java.security.UnresolvedPermission;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.easysearch.cli.Terminal;
import org.easysearch.cli.UserException;
import org.easysearch.core.internal.io.IOUtils;

class PluginSecurity {
    PluginSecurity() {
    }

    static void confirmPolicyExceptions(Terminal terminal, Set<String> permissions, boolean batch) throws UserException {
        ArrayList<String> requested = new ArrayList<String>(permissions);
        if (requested.isEmpty()) {
            terminal.println(Terminal.Verbosity.VERBOSE, "plugin has a policy file with no additional permissions");
        } else {
            Collections.sort(requested);
            terminal.errorPrintln(Terminal.Verbosity.NORMAL, "@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@");
            terminal.errorPrintln(Terminal.Verbosity.NORMAL, "@     WARNING: plugin requires additional permissions     @");
            terminal.errorPrintln(Terminal.Verbosity.NORMAL, "@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@");
            for (String permission : requested) {
                terminal.errorPrintln(Terminal.Verbosity.NORMAL, "* " + permission);
            }
            terminal.errorPrintln(Terminal.Verbosity.NORMAL, "See http://docs.oracle.com/javase/8/docs/technotes/guides/security/permissions.html");
            terminal.errorPrintln(Terminal.Verbosity.NORMAL, "for descriptions of what these permissions allow and the associated risks.");
            PluginSecurity.prompt(terminal, batch);
        }
    }

    private static void prompt(Terminal terminal, boolean batch) throws UserException {
        if (!batch) {
            terminal.println(Terminal.Verbosity.NORMAL, "");
            String text = terminal.readText("Continue with installation? [y/N]");
            if (!text.equalsIgnoreCase("y")) {
                throw new UserException(65, "installation aborted by user");
            }
        }
    }

    static String formatPermission(Permission permission) {
        StringBuilder sb = new StringBuilder();
        String clazz = null;
        clazz = permission instanceof UnresolvedPermission ? ((UnresolvedPermission)permission).getUnresolvedType() : permission.getClass().getName();
        sb.append(clazz);
        String name = null;
        name = permission instanceof UnresolvedPermission ? ((UnresolvedPermission)permission).getUnresolvedName() : permission.getName();
        if (name != null && name.length() > 0) {
            sb.append(' ');
            sb.append(name);
        }
        String actions = null;
        actions = permission instanceof UnresolvedPermission ? ((UnresolvedPermission)permission).getUnresolvedActions() : permission.getActions();
        if (actions != null && actions.length() > 0) {
            sb.append(' ');
            sb.append(actions);
        }
        return sb.toString();
    }

    public static Set<String> parsePermissions(Path file, Path tmpDir) throws IOException {
        Policy policy;
        Policy emptyPolicy;
        Path emptyPolicyFile = Files.createTempFile(tmpDir, "empty", "tmp", new FileAttribute[0]);
        try {
            emptyPolicy = Policy.getInstance("JavaPolicy", new URIParameter(emptyPolicyFile.toUri()));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        IOUtils.rm(emptyPolicyFile);
        try {
            policy = Policy.getInstance("JavaPolicy", new URIParameter(file.toUri()));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        PermissionCollection permissions = policy.getPermissions(PluginSecurity.class.getProtectionDomain());
        if (permissions == Policy.UNSUPPORTED_EMPTY_COLLECTION) {
            throw new UnsupportedOperationException("JavaPolicy implementation does not support retrieving permissions");
        }
        Permissions actualPermissions = new Permissions();
        for (Permission permission : Collections.list(permissions.elements())) {
            if (emptyPolicy.implies(PluginSecurity.class.getProtectionDomain(), permission)) continue;
            ((PermissionCollection)actualPermissions).add(permission);
        }
        return Collections.list(((PermissionCollection)actualPermissions).elements()).stream().map(PluginSecurity::formatPermission).collect(Collectors.toSet());
    }
}

