/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.indices.recovery;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.easysearch.common.io.stream.StreamInput;
import org.easysearch.common.io.stream.StreamOutput;
import org.easysearch.index.shard.ShardId;
import org.easysearch.indices.recovery.RecoveryTransportRequest;

public class RecoveryFilesInfoRequest
extends RecoveryTransportRequest {
    private long recoveryId;
    private ShardId shardId;
    List<String> phase1FileNames;
    List<Long> phase1FileSizes;
    List<String> phase1ExistingFileNames;
    List<Long> phase1ExistingFileSizes;
    int totalTranslogOps;

    public RecoveryFilesInfoRequest(StreamInput in) throws IOException {
        super(in);
        int i;
        this.recoveryId = in.readLong();
        this.shardId = new ShardId(in);
        int size = in.readVInt();
        this.phase1FileNames = new ArrayList<String>(size);
        for (i = 0; i < size; ++i) {
            this.phase1FileNames.add(in.readString());
        }
        size = in.readVInt();
        this.phase1FileSizes = new ArrayList<Long>(size);
        for (i = 0; i < size; ++i) {
            this.phase1FileSizes.add(in.readVLong());
        }
        size = in.readVInt();
        this.phase1ExistingFileNames = new ArrayList<String>(size);
        for (i = 0; i < size; ++i) {
            this.phase1ExistingFileNames.add(in.readString());
        }
        size = in.readVInt();
        this.phase1ExistingFileSizes = new ArrayList<Long>(size);
        for (i = 0; i < size; ++i) {
            this.phase1ExistingFileSizes.add(in.readVLong());
        }
        this.totalTranslogOps = in.readVInt();
    }

    RecoveryFilesInfoRequest(long recoveryId, long requestSeqNo, ShardId shardId, List<String> phase1FileNames, List<Long> phase1FileSizes, List<String> phase1ExistingFileNames, List<Long> phase1ExistingFileSizes, int totalTranslogOps) {
        super(requestSeqNo);
        this.recoveryId = recoveryId;
        this.shardId = shardId;
        this.phase1FileNames = phase1FileNames;
        this.phase1FileSizes = phase1FileSizes;
        this.phase1ExistingFileNames = phase1ExistingFileNames;
        this.phase1ExistingFileSizes = phase1ExistingFileSizes;
        this.totalTranslogOps = totalTranslogOps;
    }

    public long recoveryId() {
        return this.recoveryId;
    }

    public ShardId shardId() {
        return this.shardId;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeLong(this.recoveryId);
        this.shardId.writeTo(out);
        out.writeVInt(this.phase1FileNames.size());
        for (String phase1FileName : this.phase1FileNames) {
            out.writeString(phase1FileName);
        }
        out.writeVInt(this.phase1FileSizes.size());
        for (Long phase1FileSize : this.phase1FileSizes) {
            out.writeVLong(phase1FileSize);
        }
        out.writeVInt(this.phase1ExistingFileNames.size());
        for (String phase1ExistingFileName : this.phase1ExistingFileNames) {
            out.writeString(phase1ExistingFileName);
        }
        out.writeVInt(this.phase1ExistingFileSizes.size());
        for (Long phase1ExistingFileSize : this.phase1ExistingFileSizes) {
            out.writeVLong(phase1ExistingFileSize);
        }
        out.writeVInt(this.totalTranslogOps);
    }
}

