/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.index.shard;

import java.io.IOException;
import org.easysearch.EasysearchException;
import org.easysearch.common.io.stream.StreamInput;
import org.easysearch.common.io.stream.StreamOutput;
import org.easysearch.index.shard.IndexShardState;
import org.easysearch.index.shard.ShardId;
import org.easysearch.rest.RestStatus;

public class IllegalIndexShardStateException
extends EasysearchException {
    private final IndexShardState currentState;

    public IllegalIndexShardStateException(ShardId shardId, IndexShardState currentState, String msg, Object ... args) {
        this(shardId, currentState, msg, null, args);
    }

    public IllegalIndexShardStateException(ShardId shardId, IndexShardState currentState, String msg, Throwable ex, Object ... args) {
        super("CurrentState[" + currentState + "] " + msg, ex, args);
        this.setShard(shardId);
        this.currentState = currentState;
    }

    public IndexShardState currentState() {
        return this.currentState;
    }

    public IllegalIndexShardStateException(StreamInput in) throws IOException {
        super(in);
        this.currentState = IndexShardState.fromId(in.readByte());
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeByte(this.currentState.id());
    }

    @Override
    public RestStatus status() {
        return RestStatus.NOT_FOUND;
    }
}

