/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.index.rankeval;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.stream.Collectors;
import org.easysearch.common.ParseField;
import org.easysearch.common.io.stream.StreamInput;
import org.easysearch.common.io.stream.StreamOutput;
import org.easysearch.common.xcontent.ConstructingObjectParser;
import org.easysearch.common.xcontent.ToXContent;
import org.easysearch.common.xcontent.XContentBuilder;
import org.easysearch.common.xcontent.XContentParser;
import org.easysearch.index.rankeval.EvalQueryQuality;
import org.easysearch.index.rankeval.EvaluationMetric;
import org.easysearch.index.rankeval.MetricDetail;
import org.easysearch.index.rankeval.RatedDocument;
import org.easysearch.index.rankeval.RatedSearchHit;
import org.easysearch.search.SearchHit;

public class DiscountedCumulativeGain
implements EvaluationMetric {
    private final boolean normalize;
    private static final int DEFAULT_K = 10;
    private final int k;
    private final Integer unknownDocRating;
    public static final String NAME = "dcg";
    private static final double LOG2 = Math.log(2.0);
    private static final ParseField K_FIELD = new ParseField("k", new String[0]);
    private static final ParseField NORMALIZE_FIELD = new ParseField("normalize", new String[0]);
    private static final ParseField UNKNOWN_DOC_RATING_FIELD = new ParseField("unknown_doc_rating", new String[0]);
    private static final ConstructingObjectParser<DiscountedCumulativeGain, Void> PARSER = new ConstructingObjectParser("dcg", false, args -> {
        Boolean normalized = (Boolean)args[0];
        Integer optK = (Integer)args[2];
        return new DiscountedCumulativeGain(normalized == null ? false : normalized, (Integer)args[1], optK == null ? 10 : optK);
    });

    public DiscountedCumulativeGain() {
        this(false, null, 10);
    }

    public DiscountedCumulativeGain(boolean normalize, Integer unknownDocRating, int k) {
        this.normalize = normalize;
        this.unknownDocRating = unknownDocRating;
        this.k = k;
    }

    DiscountedCumulativeGain(StreamInput in) throws IOException {
        this.normalize = in.readBoolean();
        this.unknownDocRating = in.readOptionalVInt();
        this.k = in.readVInt();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeBoolean(this.normalize);
        out.writeOptionalVInt(this.unknownDocRating);
        out.writeVInt(this.k);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    boolean getNormalize() {
        return this.normalize;
    }

    int getK() {
        return this.k;
    }

    public Integer getUnknownDocRating() {
        return this.unknownDocRating;
    }

    @Override
    public OptionalInt forcedSearchSize() {
        return OptionalInt.of(this.k);
    }

    @Override
    public EvalQueryQuality evaluate(String taskId, SearchHit[] hits, List<RatedDocument> ratedDocs) {
        double dcg;
        List<RatedSearchHit> ratedHits = EvaluationMetric.joinHitsWithRatings(hits, ratedDocs);
        ArrayList<Integer> ratingsInSearchHits = new ArrayList<Integer>(ratedHits.size());
        int unratedResults = 0;
        for (RatedSearchHit hit : ratedHits) {
            if (hit.getRating().isPresent()) {
                ratingsInSearchHits.add(hit.getRating().getAsInt());
            } else {
                ratingsInSearchHits.add(this.unknownDocRating);
            }
            if (hit.getRating().isPresent()) continue;
            ++unratedResults;
        }
        double result = dcg = DiscountedCumulativeGain.computeDCG(ratingsInSearchHits);
        double idcg = 0.0;
        if (this.normalize) {
            List allRatings = ratedDocs.stream().mapToInt(RatedDocument::getRating).boxed().collect(Collectors.toList());
            Collections.sort(allRatings, Comparator.nullsLast(Collections.reverseOrder()));
            idcg = DiscountedCumulativeGain.computeDCG(allRatings.subList(0, Math.min(ratingsInSearchHits.size(), allRatings.size())));
            result = idcg != 0.0 ? dcg / idcg : 0.0;
        }
        EvalQueryQuality evalQueryQuality = new EvalQueryQuality(taskId, result);
        evalQueryQuality.addHitsAndRatings(ratedHits);
        evalQueryQuality.setMetricDetails(new Detail(dcg, idcg, unratedResults));
        return evalQueryQuality;
    }

    private static double computeDCG(List<Integer> ratings) {
        int rank = 1;
        double dcg = 0.0;
        for (Integer rating : ratings) {
            if (rating != null) {
                dcg += (Math.pow(2.0, rating.intValue()) - 1.0) / (Math.log(rank + 1) / LOG2);
            }
            ++rank;
        }
        return dcg;
    }

    public static DiscountedCumulativeGain fromXContent(XContentParser parser) {
        return PARSER.apply(parser, null);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startObject(NAME);
        builder.field(NORMALIZE_FIELD.getPreferredName(), this.normalize);
        if (this.unknownDocRating != null) {
            builder.field(UNKNOWN_DOC_RATING_FIELD.getPreferredName(), this.unknownDocRating);
        }
        builder.field(K_FIELD.getPreferredName(), this.k);
        builder.endObject();
        builder.endObject();
        return builder;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DiscountedCumulativeGain other = (DiscountedCumulativeGain)obj;
        return Objects.equals(this.normalize, other.normalize) && Objects.equals(this.unknownDocRating, other.unknownDocRating) && Objects.equals(this.k, other.k);
    }

    public final int hashCode() {
        return Objects.hash(this.normalize, this.unknownDocRating, this.k);
    }

    static {
        PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), NORMALIZE_FIELD);
        PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), UNKNOWN_DOC_RATING_FIELD);
        PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), K_FIELD);
    }

    public static final class Detail
    implements MetricDetail {
        private static ParseField DCG_FIELD = new ParseField("dcg", new String[0]);
        private static ParseField IDCG_FIELD = new ParseField("ideal_dcg", new String[0]);
        private static ParseField NDCG_FIELD = new ParseField("normalized_dcg", new String[0]);
        private static ParseField UNRATED_FIELD = new ParseField("unrated_docs", new String[0]);
        private final double dcg;
        private final double idcg;
        private final int unratedDocs;
        private static final ConstructingObjectParser<Detail, Void> PARSER = new ConstructingObjectParser("dcg", true, args -> new Detail((Double)args[0], (Double)args[1] != null ? (Double)args[1] : 0.0, (Integer)args[2]));

        Detail(double dcg, double idcg, int unratedDocs) {
            this.dcg = dcg;
            this.idcg = idcg;
            this.unratedDocs = unratedDocs;
        }

        Detail(StreamInput in) throws IOException {
            this.dcg = in.readDouble();
            this.idcg = in.readDouble();
            this.unratedDocs = in.readVInt();
        }

        @Override
        public String getMetricName() {
            return DiscountedCumulativeGain.NAME;
        }

        @Override
        public XContentBuilder innerToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field(DCG_FIELD.getPreferredName(), this.dcg);
            if (this.idcg != 0.0) {
                builder.field(IDCG_FIELD.getPreferredName(), this.idcg);
                builder.field(NDCG_FIELD.getPreferredName(), this.dcg / this.idcg);
            }
            builder.field(UNRATED_FIELD.getPreferredName(), this.unratedDocs);
            return builder;
        }

        public static Detail fromXContent(XContentParser parser) {
            return PARSER.apply(parser, null);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeDouble(this.dcg);
            out.writeDouble(this.idcg);
            out.writeVInt(this.unratedDocs);
        }

        @Override
        public String getWriteableName() {
            return DiscountedCumulativeGain.NAME;
        }

        public double getDCG() {
            return this.dcg;
        }

        public double getIDCG() {
            return this.idcg;
        }

        public double getNDCG() {
            return this.idcg != 0.0 ? this.dcg / this.idcg : 0.0;
        }

        public Object getUnratedDocs() {
            return this.unratedDocs;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Detail other = (Detail)obj;
            return Double.compare(this.dcg, other.dcg) == 0 && Double.compare(this.idcg, other.idcg) == 0 && this.unratedDocs == other.unratedDocs;
        }

        public int hashCode() {
            return Objects.hash(this.dcg, this.idcg, this.unratedDocs);
        }

        static {
            PARSER.declareDouble(ConstructingObjectParser.constructorArg(), DCG_FIELD);
            PARSER.declareDouble(ConstructingObjectParser.optionalConstructorArg(), IDCG_FIELD);
            PARSER.declareInt(ConstructingObjectParser.constructorArg(), UNRATED_FIELD);
        }
    }
}

