/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.index.query;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BooleanSupplier;
import java.util.function.LongSupplier;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.join.BitSetProducer;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.util.SetOnce;
import org.easysearch.Version;
import org.easysearch.action.ActionListener;
import org.easysearch.client.Client;
import org.easysearch.common.CheckedFunction;
import org.easysearch.common.ParsingException;
import org.easysearch.common.Strings;
import org.easysearch.common.TriFunction;
import org.easysearch.common.io.stream.NamedWriteableRegistry;
import org.easysearch.common.lucene.search.Queries;
import org.easysearch.common.util.BigArrays;
import org.easysearch.common.xcontent.NamedXContentRegistry;
import org.easysearch.common.xcontent.XContentParser;
import org.easysearch.index.Index;
import org.easysearch.index.IndexSettings;
import org.easysearch.index.IndexSortConfig;
import org.easysearch.index.analysis.IndexAnalyzers;
import org.easysearch.index.cache.bitset.BitsetFilterCache;
import org.easysearch.index.fielddata.IndexFieldData;
import org.easysearch.index.mapper.ContentPath;
import org.easysearch.index.mapper.DocumentMapper;
import org.easysearch.index.mapper.MappedFieldType;
import org.easysearch.index.mapper.Mapper;
import org.easysearch.index.mapper.MapperService;
import org.easysearch.index.mapper.ObjectMapper;
import org.easysearch.index.mapper.TextFieldMapper;
import org.easysearch.index.query.AbstractQueryBuilder;
import org.easysearch.index.query.ParsedQuery;
import org.easysearch.index.query.QueryBuilder;
import org.easysearch.index.query.QueryRewriteContext;
import org.easysearch.index.query.QueryShardException;
import org.easysearch.index.query.Rewriteable;
import org.easysearch.index.query.support.NestedScope;
import org.easysearch.index.similarity.SimilarityService;
import org.easysearch.script.Script;
import org.easysearch.script.ScriptContext;
import org.easysearch.script.ScriptFactory;
import org.easysearch.script.ScriptService;
import org.easysearch.search.aggregations.support.AggregationUsageService;
import org.easysearch.search.aggregations.support.ValuesSourceRegistry;
import org.easysearch.search.lookup.SearchLookup;
import org.easysearch.transport.RemoteClusterAware;

public class QueryShardContext
extends QueryRewriteContext {
    private final ScriptService scriptService;
    private final IndexSettings indexSettings;
    private final BigArrays bigArrays;
    private final MapperService mapperService;
    private final SimilarityService similarityService;
    private final BitsetFilterCache bitsetFilterCache;
    private final TriFunction<MappedFieldType, String, Supplier<SearchLookup>, IndexFieldData<?>> indexFieldDataService;
    private final int shardId;
    private final IndexSearcher searcher;
    private String[] types = Strings.EMPTY_ARRAY;
    private boolean cacheable = true;
    private final SetOnce<Boolean> frozen = new SetOnce();
    private final Index fullyQualifiedIndex;
    private final Predicate<String> indexNameMatcher;
    private final BooleanSupplier allowExpensiveQueries;
    private final Map<String, Query> namedQueries = new HashMap<String, Query>();
    private boolean allowUnmappedFields;
    private boolean mapUnmappedFieldAsString;
    private NestedScope nestedScope;
    private final ValuesSourceRegistry valuesSourceRegistry;
    private SearchLookup lookup = null;

    public void setTypes(String ... types) {
        this.types = types;
    }

    public String[] getTypes() {
        return this.types;
    }

    public QueryShardContext(int shardId, IndexSettings indexSettings, BigArrays bigArrays, BitsetFilterCache bitsetFilterCache, TriFunction<MappedFieldType, String, Supplier<SearchLookup>, IndexFieldData<?>> indexFieldDataLookup, MapperService mapperService, SimilarityService similarityService, ScriptService scriptService, NamedXContentRegistry xContentRegistry, NamedWriteableRegistry namedWriteableRegistry, Client client, IndexSearcher searcher, LongSupplier nowInMillis, String clusterAlias, Predicate<String> indexNameMatcher, BooleanSupplier allowExpensiveQueries, ValuesSourceRegistry valuesSourceRegistry) {
        this(shardId, indexSettings, bigArrays, bitsetFilterCache, indexFieldDataLookup, mapperService, similarityService, scriptService, xContentRegistry, namedWriteableRegistry, client, searcher, nowInMillis, indexNameMatcher, new Index(RemoteClusterAware.buildRemoteIndexName(clusterAlias, indexSettings.getIndex().getName()), indexSettings.getIndex().getUUID()), allowExpensiveQueries, valuesSourceRegistry);
    }

    public QueryShardContext(QueryShardContext source) {
        this(source.shardId, source.indexSettings, source.bigArrays, source.bitsetFilterCache, source.indexFieldDataService, source.mapperService, source.similarityService, source.scriptService, source.getXContentRegistry(), source.getWriteableRegistry(), source.client, source.searcher, source.nowInMillis, source.indexNameMatcher, source.fullyQualifiedIndex, source.allowExpensiveQueries, source.valuesSourceRegistry);
    }

    private QueryShardContext(int shardId, IndexSettings indexSettings, BigArrays bigArrays, BitsetFilterCache bitsetFilterCache, TriFunction<MappedFieldType, String, Supplier<SearchLookup>, IndexFieldData<?>> indexFieldDataLookup, MapperService mapperService, SimilarityService similarityService, ScriptService scriptService, NamedXContentRegistry xContentRegistry, NamedWriteableRegistry namedWriteableRegistry, Client client, IndexSearcher searcher, LongSupplier nowInMillis, Predicate<String> indexNameMatcher, Index fullyQualifiedIndex, BooleanSupplier allowExpensiveQueries, ValuesSourceRegistry valuesSourceRegistry) {
        super(xContentRegistry, namedWriteableRegistry, client, nowInMillis);
        this.shardId = shardId;
        this.similarityService = similarityService;
        this.mapperService = mapperService;
        this.bigArrays = bigArrays;
        this.bitsetFilterCache = bitsetFilterCache;
        this.indexFieldDataService = indexFieldDataLookup;
        this.allowUnmappedFields = indexSettings.isDefaultAllowUnmappedFields();
        this.nestedScope = new NestedScope();
        this.scriptService = scriptService;
        this.indexSettings = indexSettings;
        this.searcher = searcher;
        this.indexNameMatcher = indexNameMatcher;
        this.fullyQualifiedIndex = fullyQualifiedIndex;
        this.allowExpensiveQueries = allowExpensiveQueries;
        this.valuesSourceRegistry = valuesSourceRegistry;
    }

    private void reset() {
        this.allowUnmappedFields = this.indexSettings.isDefaultAllowUnmappedFields();
        this.lookup = null;
        this.namedQueries.clear();
        this.nestedScope = new NestedScope();
    }

    public IndexAnalyzers getIndexAnalyzers() {
        return this.mapperService.getIndexAnalyzers();
    }

    public Similarity getSearchSimilarity() {
        return this.similarityService != null ? this.similarityService.similarity(this.mapperService) : null;
    }

    public List<String> defaultFields() {
        return this.indexSettings.getDefaultFields();
    }

    public boolean queryStringLenient() {
        return this.indexSettings.isQueryStringLenient();
    }

    public boolean queryStringAnalyzeWildcard() {
        return this.indexSettings.isQueryStringAnalyzeWildcard();
    }

    public boolean queryStringAllowLeadingWildcard() {
        return this.indexSettings.isQueryStringAllowLeadingWildcard();
    }

    public BitSetProducer bitsetFilter(Query filter) {
        return this.bitsetFilterCache.getBitSetProducer(filter);
    }

    public boolean allowExpensiveQueries() {
        return this.allowExpensiveQueries.getAsBoolean();
    }

    public <IFD extends IndexFieldData<?>> IFD getForField(MappedFieldType fieldType) {
        return (IFD)this.indexFieldDataService.apply(fieldType, this.fullyQualifiedIndex.getName(), () -> this.lookup().forkAndTrackFieldReferences(fieldType.name()));
    }

    public void addNamedQuery(String name, Query query) {
        if (query != null) {
            this.namedQueries.put(name, query);
        }
    }

    public Map<String, Query> copyNamedQueries() {
        return Collections.unmodifiableMap(new HashMap<String, Query>(this.namedQueries));
    }

    public Set<String> simpleMatchToIndexNames(String pattern) {
        return this.mapperService.simpleMatchToFullName(pattern);
    }

    public MappedFieldType fieldMapper(String name) {
        return this.failIfFieldMappingNotFound(name, this.mapperService.fieldType(name));
    }

    public ObjectMapper getObjectMapper(String name) {
        return this.mapperService.getObjectMapper(name);
    }

    public DocumentMapper documentMapper(String type) {
        return this.mapperService.documentMapper(type);
    }

    public Analyzer getSearchAnalyzer(MappedFieldType fieldType) {
        if (fieldType.getTextSearchInfo().getSearchAnalyzer() != null) {
            return fieldType.getTextSearchInfo().getSearchAnalyzer();
        }
        return this.getMapperService().searchAnalyzer();
    }

    public Analyzer getSearchQuoteAnalyzer(MappedFieldType fieldType) {
        if (fieldType.getTextSearchInfo().getSearchQuoteAnalyzer() != null) {
            return fieldType.getTextSearchInfo().getSearchQuoteAnalyzer();
        }
        return this.getMapperService().searchQuoteAnalyzer();
    }

    public ValuesSourceRegistry getValuesSourceRegistry() {
        return this.valuesSourceRegistry;
    }

    public void setAllowUnmappedFields(boolean allowUnmappedFields) {
        this.allowUnmappedFields = allowUnmappedFields;
    }

    public void setMapUnmappedFieldAsString(boolean mapUnmappedFieldAsString) {
        this.mapUnmappedFieldAsString = mapUnmappedFieldAsString;
    }

    MappedFieldType failIfFieldMappingNotFound(String name, MappedFieldType fieldMapping) {
        if (fieldMapping != null || this.allowUnmappedFields) {
            return fieldMapping;
        }
        if (this.mapUnmappedFieldAsString) {
            TextFieldMapper.Builder builder = new TextFieldMapper.Builder(name, this.mapperService.getIndexAnalyzers());
            return builder.build(new Mapper.BuilderContext(this.indexSettings.getSettings(), new ContentPath(1))).fieldType();
        }
        throw new QueryShardException(this, "No field mapping can be found for the field with name [{}]", name);
    }

    public Collection<String> queryTypes() {
        String[] types = this.getTypes();
        if (types == null || types.length == 0 || types.length == 1 && types[0].equals("_all")) {
            DocumentMapper mapper = this.getMapperService().documentMapper();
            return mapper == null ? Collections.emptyList() : Collections.singleton(mapper.type());
        }
        return Arrays.asList(types);
    }

    public SearchLookup lookup() {
        if (this.lookup == null) {
            this.lookup = new SearchLookup(this.getMapperService(), (fieldType, searchLookup) -> this.indexFieldDataService.apply((MappedFieldType)fieldType, this.fullyQualifiedIndex.getName(), (Supplier<SearchLookup>)searchLookup), this.types);
        }
        return this.lookup;
    }

    public SearchLookup newFetchLookup() {
        return new SearchLookup(this.getMapperService(), (fieldType, searchLookup) -> this.indexFieldDataService.apply((MappedFieldType)fieldType, this.fullyQualifiedIndex.getName(), (Supplier<SearchLookup>)searchLookup), this.types);
    }

    public NestedScope nestedScope() {
        return this.nestedScope;
    }

    public Version indexVersionCreated() {
        return this.indexSettings.getIndexVersionCreated();
    }

    public boolean indexMatches(String pattern) {
        return this.indexNameMatcher.test(pattern);
    }

    public boolean indexSortedOnField(String field) {
        IndexSortConfig indexSortConfig = this.indexSettings.getIndexSortConfig();
        return indexSortConfig.hasPrimarySortOnField(field);
    }

    public ParsedQuery toQuery(QueryBuilder queryBuilder) {
        return this.toQuery(queryBuilder, q -> {
            Query query = q.toQuery(this);
            if (query == null) {
                query = Queries.newMatchNoDocsQuery("No query left after rewrite.");
            }
            return query;
        });
    }

    private ParsedQuery toQuery(QueryBuilder queryBuilder, CheckedFunction<QueryBuilder, Query, IOException> filterOrQuery) {
        this.reset();
        try {
            QueryBuilder rewriteQuery = Rewriteable.rewrite(queryBuilder, this, true);
            ParsedQuery parsedQuery = new ParsedQuery(filterOrQuery.apply(rewriteQuery), this.copyNamedQueries());
            return parsedQuery;
        }
        catch (ParsingException | QueryShardException e) {
            throw e;
        }
        catch (Exception e) {
            throw new QueryShardException(this, "failed to create query: {}", (Throwable)e, e.getMessage());
        }
        finally {
            this.reset();
        }
    }

    public Index index() {
        return this.indexSettings.getIndex();
    }

    public <FactoryType> FactoryType compile(Script script, ScriptContext<FactoryType> context) {
        FactoryType factory = this.scriptService.compile(script, context);
        if (factory instanceof ScriptFactory && !((ScriptFactory)factory).isResultDeterministic()) {
            this.failIfFrozen();
        }
        return factory;
    }

    public final void freezeContext() {
        this.frozen.set((Object)Boolean.TRUE);
    }

    protected final void failIfFrozen() {
        this.cacheable = false;
        if (this.frozen.get() == Boolean.TRUE) {
            throw new IllegalArgumentException("features that prevent cachability are disabled on this context");
        }
        assert (this.frozen.get() == null) : (Boolean)this.frozen.get();
    }

    @Override
    public void registerAsyncAction(BiConsumer<Client, ActionListener<?>> asyncAction) {
        this.failIfFrozen();
        super.registerAsyncAction(asyncAction);
    }

    @Override
    public void executeAsyncActions(ActionListener listener) {
        this.failIfFrozen();
        super.executeAsyncActions(listener);
    }

    public final boolean isCacheable() {
        return this.cacheable;
    }

    public int getShardId() {
        return this.shardId;
    }

    @Override
    public final long nowInMillis() {
        this.failIfFrozen();
        return super.nowInMillis();
    }

    public Client getClient() {
        this.failIfFrozen();
        return this.client;
    }

    public QueryBuilder parseInnerQueryBuilder(XContentParser parser) throws IOException {
        return AbstractQueryBuilder.parseInnerQueryBuilder(parser);
    }

    @Override
    public final QueryShardContext convertToShardContext() {
        return this;
    }

    public IndexSettings getIndexSettings() {
        return this.indexSettings;
    }

    public MapperService getMapperService() {
        return this.mapperService;
    }

    public IndexReader getIndexReader() {
        return this.searcher == null ? null : this.searcher.getIndexReader();
    }

    public IndexSearcher searcher() {
        return this.searcher;
    }

    public Index getFullyQualifiedIndex() {
        return this.fullyQualifiedIndex;
    }

    public BigArrays bigArrays() {
        return this.bigArrays;
    }

    public SimilarityService getSimilarityService() {
        return this.similarityService;
    }

    public BitsetFilterCache getBitsetFilterCache() {
        return this.bitsetFilterCache;
    }

    public AggregationUsageService getUsageService() {
        return this.valuesSourceRegistry.getUsageService();
    }
}

