/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.index.query;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.document.LatLonDocValuesField;
import org.apache.lucene.document.LatLonPoint;
import org.apache.lucene.search.IndexOrDocValuesQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.easysearch.EasysearchParseException;
import org.easysearch.common.Numbers;
import org.easysearch.common.ParseField;
import org.easysearch.common.ParsingException;
import org.easysearch.common.geo.GeoBoundingBox;
import org.easysearch.common.geo.GeoPoint;
import org.easysearch.common.geo.GeoUtils;
import org.easysearch.common.io.stream.StreamInput;
import org.easysearch.common.io.stream.StreamOutput;
import org.easysearch.common.xcontent.ToXContent;
import org.easysearch.common.xcontent.XContentBuilder;
import org.easysearch.common.xcontent.XContentParser;
import org.easysearch.geometry.Rectangle;
import org.easysearch.geometry.utils.Geohash;
import org.easysearch.index.mapper.GeoPointFieldMapper;
import org.easysearch.index.mapper.MappedFieldType;
import org.easysearch.index.query.AbstractQueryBuilder;
import org.easysearch.index.query.GeoExecType;
import org.easysearch.index.query.GeoValidationMethod;
import org.easysearch.index.query.QueryShardContext;
import org.easysearch.index.query.QueryShardException;
import org.easysearch.index.query.QueryValidationException;

public class GeoBoundingBoxQueryBuilder
extends AbstractQueryBuilder<GeoBoundingBoxQueryBuilder> {
    public static final String NAME = "geo_bounding_box";
    public static final GeoExecType DEFAULT_TYPE = GeoExecType.MEMORY;
    public static final boolean DEFAULT_IGNORE_UNMAPPED = false;
    private static final ParseField TYPE_FIELD = new ParseField("type", new String[0]);
    private static final ParseField VALIDATION_METHOD_FIELD = new ParseField("validation_method", new String[0]);
    private static final ParseField IGNORE_UNMAPPED_FIELD = new ParseField("ignore_unmapped", new String[0]);
    private final String fieldName;
    private GeoBoundingBox geoBoundingBox = new GeoBoundingBox(new GeoPoint(Double.NaN, Double.NaN), new GeoPoint(Double.NaN, Double.NaN));
    private GeoValidationMethod validationMethod = GeoValidationMethod.DEFAULT;
    private GeoExecType type = DEFAULT_TYPE;
    private boolean ignoreUnmapped = false;

    public GeoBoundingBoxQueryBuilder(String fieldName) {
        if (fieldName == null) {
            throw new IllegalArgumentException("Field name must not be empty.");
        }
        this.fieldName = fieldName;
    }

    public GeoBoundingBoxQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.fieldName = in.readString();
        this.geoBoundingBox = new GeoBoundingBox(in);
        this.type = GeoExecType.readFromStream(in);
        this.validationMethod = GeoValidationMethod.readFromStream(in);
        this.ignoreUnmapped = in.readBoolean();
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeString(this.fieldName);
        this.geoBoundingBox.writeTo(out);
        this.type.writeTo(out);
        this.validationMethod.writeTo(out);
        out.writeBoolean(this.ignoreUnmapped);
    }

    public GeoBoundingBoxQueryBuilder setCorners(double top, double left, double bottom, double right) {
        if (!GeoValidationMethod.isIgnoreMalformed(this.validationMethod)) {
            if (!Numbers.isValidDouble(top)) {
                throw new IllegalArgumentException("top latitude is invalid: " + top);
            }
            if (!Numbers.isValidDouble(left)) {
                throw new IllegalArgumentException("left longitude is invalid: " + left);
            }
            if (!Numbers.isValidDouble(bottom)) {
                throw new IllegalArgumentException("bottom latitude is invalid: " + bottom);
            }
            if (!Numbers.isValidDouble(right)) {
                throw new IllegalArgumentException("right longitude is invalid: " + right);
            }
            if (top < bottom) {
                throw new IllegalArgumentException("top is below bottom corner: " + top + " vs. " + bottom);
            }
            if (top == bottom) {
                throw new IllegalArgumentException("top cannot be the same as bottom: " + top + " == " + bottom);
            }
            if (left == right) {
                throw new IllegalArgumentException("left cannot be the same as right: " + left + " == " + right);
            }
        }
        this.geoBoundingBox.topLeft().reset(top, left);
        this.geoBoundingBox.bottomRight().reset(bottom, right);
        return this;
    }

    public GeoBoundingBoxQueryBuilder setCorners(GeoPoint topLeft, GeoPoint bottomRight) {
        return this.setCorners(topLeft.getLat(), topLeft.getLon(), bottomRight.getLat(), bottomRight.getLon());
    }

    public GeoBoundingBoxQueryBuilder setCorners(String geohash) {
        Rectangle ghBBox = Geohash.toBoundingBox(geohash);
        return this.setCorners(new GeoPoint(ghBBox.getMaxY(), ghBBox.getMinX()), new GeoPoint(ghBBox.getMinY(), ghBBox.getMaxX()));
    }

    public GeoBoundingBoxQueryBuilder setCorners(String topLeft, String bottomRight) {
        return this.setCorners(GeoPoint.fromGeohash(topLeft), GeoPoint.fromGeohash(bottomRight));
    }

    public GeoPoint topLeft() {
        return this.geoBoundingBox.topLeft();
    }

    public GeoPoint bottomRight() {
        return this.geoBoundingBox.bottomRight();
    }

    public GeoBoundingBoxQueryBuilder setCornersOGC(GeoPoint bottomLeft, GeoPoint topRight) {
        return this.setCorners(topRight.getLat(), bottomLeft.getLon(), bottomLeft.getLat(), topRight.getLon());
    }

    public GeoBoundingBoxQueryBuilder setCornersOGC(String bottomLeft, String topRight) {
        return this.setCornersOGC(GeoPoint.fromGeohash(bottomLeft), GeoPoint.fromGeohash(topRight));
    }

    public GeoBoundingBoxQueryBuilder setValidationMethod(GeoValidationMethod method) {
        this.validationMethod = method;
        return this;
    }

    public GeoValidationMethod getValidationMethod() {
        return this.validationMethod;
    }

    public GeoBoundingBoxQueryBuilder type(GeoExecType type) {
        if (type == null) {
            throw new IllegalArgumentException("Type is not allowed to be null.");
        }
        this.type = type;
        return this;
    }

    public GeoBoundingBoxQueryBuilder type(String type) {
        this.type = GeoExecType.fromString(type);
        return this;
    }

    public GeoExecType type() {
        return this.type;
    }

    public String fieldName() {
        return this.fieldName;
    }

    public GeoBoundingBoxQueryBuilder ignoreUnmapped(boolean ignoreUnmapped) {
        this.ignoreUnmapped = ignoreUnmapped;
        return this;
    }

    public boolean ignoreUnmapped() {
        return this.ignoreUnmapped;
    }

    QueryValidationException checkLatLon() {
        if (GeoValidationMethod.isIgnoreMalformed(this.validationMethod)) {
            return null;
        }
        GeoPoint topLeft = this.geoBoundingBox.topLeft();
        GeoPoint bottomRight = this.geoBoundingBox.bottomRight();
        QueryValidationException validationException = null;
        if (!GeoUtils.isValidLatitude(topLeft.getLat())) {
            validationException = this.addValidationError("top latitude is invalid: " + topLeft.getLat(), validationException);
        }
        if (!GeoUtils.isValidLongitude(topLeft.getLon())) {
            validationException = this.addValidationError("left longitude is invalid: " + topLeft.getLon(), validationException);
        }
        if (!GeoUtils.isValidLatitude(bottomRight.getLat())) {
            validationException = this.addValidationError("bottom latitude is invalid: " + bottomRight.getLat(), validationException);
        }
        if (!GeoUtils.isValidLongitude(bottomRight.getLon())) {
            validationException = this.addValidationError("right longitude is invalid: " + bottomRight.getLon(), validationException);
        }
        return validationException;
    }

    @Override
    public Query doToQuery(QueryShardContext context) {
        MappedFieldType fieldType = context.fieldMapper(this.fieldName);
        if (fieldType == null) {
            if (this.ignoreUnmapped) {
                return new MatchNoDocsQuery();
            }
            throw new QueryShardException(context, "failed to find geo_point field [" + this.fieldName + "]", new Object[0]);
        }
        if (!(fieldType instanceof GeoPointFieldMapper.GeoPointFieldType)) {
            throw new QueryShardException(context, "field [" + this.fieldName + "] is not a geo_point field", new Object[0]);
        }
        QueryValidationException exception = this.checkLatLon();
        if (exception != null) {
            throw new QueryShardException(context, "couldn't validate latitude/ longitude values", (Throwable)exception, new Object[0]);
        }
        GeoPoint luceneTopLeft = new GeoPoint(this.geoBoundingBox.topLeft());
        GeoPoint luceneBottomRight = new GeoPoint(this.geoBoundingBox.bottomRight());
        if (GeoValidationMethod.isCoerce(this.validationMethod)) {
            double left;
            double right = luceneBottomRight.getLon();
            boolean completeLonRange = (right - (left = luceneTopLeft.getLon())) % 360.0 == 0.0 && right > left;
            GeoUtils.normalizePoint(luceneTopLeft, true, !completeLonRange);
            GeoUtils.normalizePoint(luceneBottomRight, true, !completeLonRange);
            if (completeLonRange) {
                luceneTopLeft.resetLon(-180.0);
                luceneBottomRight.resetLon(180.0);
            }
        }
        Query query = LatLonPoint.newBoxQuery((String)fieldType.name(), (double)luceneBottomRight.getLat(), (double)luceneTopLeft.getLat(), (double)luceneTopLeft.getLon(), (double)luceneBottomRight.getLon());
        if (fieldType.hasDocValues()) {
            Query dvQuery = LatLonDocValuesField.newSlowBoxQuery((String)fieldType.name(), (double)luceneBottomRight.getLat(), (double)luceneTopLeft.getLat(), (double)luceneTopLeft.getLon(), (double)luceneBottomRight.getLon());
            query = new IndexOrDocValuesQuery(query, dvQuery);
        }
        return query;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        builder.startObject(this.fieldName);
        this.geoBoundingBox.toXContentFragment(builder, false);
        builder.endObject();
        builder.field(VALIDATION_METHOD_FIELD.getPreferredName(), this.validationMethod);
        builder.field(TYPE_FIELD.getPreferredName(), this.type);
        builder.field(IGNORE_UNMAPPED_FIELD.getPreferredName(), this.ignoreUnmapped);
        this.printBoostAndQueryName(builder);
        builder.endObject();
    }

    public static GeoBoundingBoxQueryBuilder fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        String fieldName = null;
        float boost = 1.0f;
        String queryName = null;
        String currentFieldName = null;
        GeoValidationMethod validationMethod = null;
        boolean ignoreUnmapped = false;
        GeoBoundingBox bbox = null;
        String type = "memory";
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                try {
                    bbox = GeoBoundingBox.parseBoundingBox(parser);
                    fieldName = currentFieldName;
                    continue;
                }
                catch (Exception e) {
                    throw new EasysearchParseException("failed to parse [{}] query. [{}]", NAME, e.getMessage());
                }
            }
            if (!token.isValue()) continue;
            if (AbstractQueryBuilder.NAME_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                queryName = parser.text();
                continue;
            }
            if (AbstractQueryBuilder.BOOST_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                boost = parser.floatValue();
                continue;
            }
            if (VALIDATION_METHOD_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                validationMethod = GeoValidationMethod.fromString(parser.text());
                continue;
            }
            if (IGNORE_UNMAPPED_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                ignoreUnmapped = parser.booleanValue();
                continue;
            }
            if (TYPE_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                type = parser.text();
                continue;
            }
            throw new ParsingException(parser.getTokenLocation(), "failed to parse [{}] query. unexpected field [{}]", NAME, currentFieldName);
        }
        if (bbox == null) {
            throw new EasysearchParseException("failed to parse [{}] query. bounding box not provided", NAME);
        }
        GeoBoundingBoxQueryBuilder builder = new GeoBoundingBoxQueryBuilder(fieldName);
        builder.setCorners(bbox.topLeft(), bbox.bottomRight());
        builder.queryName(queryName);
        builder.boost(boost);
        builder.type(GeoExecType.fromString(type));
        builder.ignoreUnmapped(ignoreUnmapped);
        if (validationMethod != null) {
            builder.setValidationMethod(validationMethod);
        }
        return builder;
    }

    @Override
    protected boolean doEquals(GeoBoundingBoxQueryBuilder other) {
        return Objects.equals(this.geoBoundingBox, other.geoBoundingBox) && Objects.equals(this.type, other.type) && Objects.equals(this.validationMethod, other.validationMethod) && Objects.equals(this.fieldName, other.fieldName) && Objects.equals(this.ignoreUnmapped, other.ignoreUnmapped);
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.geoBoundingBox, this.type, this.validationMethod, this.fieldName, this.ignoreUnmapped);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }
}

