/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.index.mapper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Consumer;
import org.apache.lucene.index.IndexOptions;
import org.easysearch.EasysearchParseException;
import org.easysearch.common.logging.DeprecationLogger;
import org.easysearch.common.time.DateFormatter;
import org.easysearch.common.xcontent.support.XContentMapValues;
import org.easysearch.index.mapper.DocumentMapperParser;
import org.easysearch.index.mapper.FieldMapper;
import org.easysearch.index.mapper.Mapper;
import org.easysearch.index.mapper.MapperParsingException;
import org.easysearch.index.similarity.SimilarityProvider;

public class TypeParsers {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(TypeParsers.class);
    public static final String DOC_VALUES = "doc_values";
    public static final String INDEX_OPTIONS_DOCS = "docs";
    public static final String INDEX_OPTIONS_FREQS = "freqs";
    public static final String INDEX_OPTIONS_POSITIONS = "positions";
    public static final String INDEX_OPTIONS_OFFSETS = "offsets";

    public static void checkNull(String propName, Object propNode) {
        if (!propName.equals("null_value") && propNode == null) {
            throw new MapperParsingException("[" + propName + "] must not have a [null] value");
        }
    }

    public static Map<String, String> parseMeta(String name, Object metaObject) {
        if (!(metaObject instanceof Map)) {
            throw new MapperParsingException("[meta] must be an object, got " + metaObject.getClass().getSimpleName() + "[" + metaObject + "] for field [" + name + "]");
        }
        Map meta = (Map)metaObject;
        if (meta.size() > 5) {
            throw new MapperParsingException("[meta] can't have more than 5 entries, but got " + meta.size() + " on field [" + name + "]");
        }
        for (String key : meta.keySet()) {
            if (key.codePointCount(0, key.length()) <= 20) continue;
            throw new MapperParsingException("[meta] keys can't be longer than 20 chars, but got [" + key + "] for field [" + name + "]");
        }
        for (Object value : meta.values()) {
            if (value instanceof String) {
                String sValue = (String)value;
                if (sValue.codePointCount(0, sValue.length()) <= 50) continue;
                throw new MapperParsingException("[meta] values can't be longer than 50 chars, but got [" + value + "] for field [" + name + "]");
            }
            if (value == null) {
                throw new MapperParsingException("[meta] values can't be null (field [" + name + "])");
            }
            throw new MapperParsingException("[meta] values can only be strings, but got " + value.getClass().getSimpleName() + "[" + value + "] for field [" + name + "]");
        }
        TreeMap<String, String> sortedMeta = new TreeMap<String, String>();
        for (Map.Entry entry : meta.entrySet()) {
            sortedMeta.put((String)entry.getKey(), (String)entry.getValue());
        }
        return Collections.unmodifiableMap(sortedMeta);
    }

    public static void parseField(FieldMapper.Builder<?> builder, String name, Map<String, Object> fieldNode, Mapper.TypeParser.ParserContext parserContext) {
        Iterator<Map.Entry<String, Object>> iterator = fieldNode.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Object> entry = iterator.next();
            String propName = entry.getKey();
            Object propNode = entry.getValue();
            TypeParsers.checkNull(propName, propNode);
            if (propName.equals("store")) {
                builder.store(XContentMapValues.nodeBooleanValue(propNode, name + ".store"));
                iterator.remove();
                continue;
            }
            if (propName.equals("meta")) {
                builder.meta(TypeParsers.parseMeta(name, propNode));
                iterator.remove();
                continue;
            }
            if (propName.equals("index")) {
                builder.index(XContentMapValues.nodeBooleanValue(propNode, name + ".index"));
                iterator.remove();
                continue;
            }
            if (propName.equals(DOC_VALUES)) {
                builder.docValues(XContentMapValues.nodeBooleanValue(propNode, name + ".doc_values"));
                iterator.remove();
                continue;
            }
            if (propName.equals("boost")) {
                builder.boost(XContentMapValues.nodeFloatValue(propNode));
                deprecationLogger.deprecate("boost", "Parameter [boost] on field [{}] is deprecated and will be removed in 8.0", name);
                iterator.remove();
                continue;
            }
            if (propName.equals("index_options")) {
                builder.indexOptions(TypeParsers.nodeIndexOptionValue(propNode));
                iterator.remove();
                continue;
            }
            if (propName.equals("similarity")) {
                deprecationLogger.deprecate("similarity", "The [similarity] parameter has no effect on field [" + name + "] and will be removed in 8.0", new Object[0]);
                iterator.remove();
                continue;
            }
            if (TypeParsers.parseMultiField(builder::addMultiField, name, parserContext, propName, propNode)) {
                iterator.remove();
                continue;
            }
            if (!propName.equals("copy_to")) continue;
            if (parserContext.isWithinMultiField()) {
                throw new MapperParsingException("copy_to in multi fields is not allowed. Found the copy_to in field [" + name + "] which is within a multi field.");
            }
            List<String> copyFields = TypeParsers.parseCopyFields(propNode);
            FieldMapper.CopyTo.Builder cpBuilder = new FieldMapper.CopyTo.Builder();
            copyFields.forEach(cpBuilder::add);
            builder.copyTo(cpBuilder.build());
            iterator.remove();
        }
    }

    public static boolean parseMultiField(Consumer<Mapper.Builder> multiFieldsBuilder, String name, Mapper.TypeParser.ParserContext parserContext, String propName, Object propNode) {
        if (propName.equals("fields")) {
            Map multiFieldsPropNodes;
            if (parserContext.isWithinMultiField()) {
                deprecationLogger.deprecate("multifield_within_multifield", "At least one multi-field, [" + name + "], was encountered that itself contains a multi-field. Defining multi-fields within a multi-field is deprecated and will no longer be supported in 8.0. To resolve the issue, all instances of [fields] that occur within a [fields] block should be removed from the mappings, either by flattening the chained [fields] blocks into a single level, or switching to [copy_to] if appropriate.", new Object[0]);
            }
            parserContext = parserContext.createMultiFieldContext(parserContext);
            if (propNode instanceof List && ((List)propNode).isEmpty()) {
                multiFieldsPropNodes = Collections.emptyMap();
            } else if (propNode instanceof Map) {
                multiFieldsPropNodes = (Map)propNode;
            } else {
                throw new MapperParsingException("expected map for property [fields] on field [" + propNode + "] or [" + propName + "] but got a " + propNode.getClass());
            }
            for (Map.Entry multiFieldEntry : multiFieldsPropNodes.entrySet()) {
                String multiFieldName = (String)multiFieldEntry.getKey();
                if (multiFieldName.contains(".")) {
                    throw new MapperParsingException("Field name [" + multiFieldName + "] which is a multi field of [" + name + "] cannot contain '.'");
                }
                if (!(multiFieldEntry.getValue() instanceof Map)) {
                    throw new MapperParsingException("illegal field [" + multiFieldName + "], only fields can be specified inside fields");
                }
                Map multiFieldNodes = (Map)multiFieldEntry.getValue();
                Object typeNode = multiFieldNodes.get("type");
                if (typeNode == null) {
                    throw new MapperParsingException("no type specified for property [" + multiFieldName + "]");
                }
                String type = typeNode.toString();
                if (type.equals("object") || type.equals("nested") || type.equals("alias")) {
                    throw new MapperParsingException("Type [" + type + "] cannot be used in multi field");
                }
                Mapper.TypeParser typeParser = parserContext.typeParser(type);
                if (typeParser == null) {
                    throw new MapperParsingException("no handler for type [" + type + "] declared on field [" + multiFieldName + "]");
                }
                multiFieldsBuilder.accept(typeParser.parse(multiFieldName, multiFieldNodes, parserContext));
                multiFieldNodes.remove("type");
                DocumentMapperParser.checkNoRemainingFields(propName, multiFieldNodes, parserContext.indexVersionCreated());
            }
            return true;
        }
        return false;
    }

    private static IndexOptions nodeIndexOptionValue(Object propNode) {
        String value = propNode.toString();
        if (INDEX_OPTIONS_OFFSETS.equalsIgnoreCase(value)) {
            return IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS;
        }
        if (INDEX_OPTIONS_POSITIONS.equalsIgnoreCase(value)) {
            return IndexOptions.DOCS_AND_FREQS_AND_POSITIONS;
        }
        if (INDEX_OPTIONS_FREQS.equalsIgnoreCase(value)) {
            return IndexOptions.DOCS_AND_FREQS;
        }
        if (INDEX_OPTIONS_DOCS.equalsIgnoreCase(value)) {
            return IndexOptions.DOCS;
        }
        throw new EasysearchParseException("failed to parse index option [{}]", value);
    }

    public static DateFormatter parseDateTimeFormatter(Object node) {
        if (node instanceof String) {
            return DateFormatter.forPattern((String)node);
        }
        throw new IllegalArgumentException("Invalid format: [" + node.toString() + "]: expected string value");
    }

    public static List<String> parseCopyFields(Object propNode) {
        ArrayList<String> copyFields = new ArrayList<String>();
        if (XContentMapValues.isArray(propNode)) {
            for (Object node : (List)propNode) {
                copyFields.add(XContentMapValues.nodeStringValue(node, null));
            }
        } else {
            copyFields.add(XContentMapValues.nodeStringValue(propNode, null));
        }
        return copyFields;
    }

    public static SimilarityProvider resolveSimilarity(Mapper.TypeParser.ParserContext parserContext, String name, Object value) {
        if (value == null) {
            return null;
        }
        SimilarityProvider similarityProvider = parserContext.getSimilarity(value.toString());
        if (similarityProvider == null) {
            throw new MapperParsingException("Unknown Similarity type [" + value + "] for field [" + name + "]");
        }
        return similarityProvider;
    }
}

