/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.index.mapper;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.easysearch.common.collect.List;
import org.easysearch.common.xcontent.support.XContentMapValues;
import org.easysearch.index.analysis.NamedAnalyzer;
import org.easysearch.index.mapper.DocValueFetcher;
import org.easysearch.index.mapper.FieldMapper;
import org.easysearch.index.mapper.MappedFieldType;
import org.easysearch.index.mapper.Mapper;
import org.easysearch.index.mapper.MapperParsingException;
import org.easysearch.index.mapper.MapperService;
import org.easysearch.index.mapper.NumberFieldMapper;
import org.easysearch.index.mapper.ParametrizedFieldMapper;
import org.easysearch.index.mapper.ParseContext;
import org.easysearch.index.mapper.ValueFetcher;
import org.easysearch.search.lookup.SearchLookup;

public class TokenCountFieldMapper
extends ParametrizedFieldMapper {
    public static final String CONTENT_TYPE = "token_count";
    public static ParametrizedFieldMapper.TypeParser PARSER = new ParametrizedFieldMapper.TypeParser((n, c) -> new Builder((String)n));
    private final boolean index;
    private final boolean hasDocValues;
    private final boolean store;
    private final NamedAnalyzer analyzer;
    private final boolean enablePositionIncrements;
    private final Integer nullValue;

    private static TokenCountFieldMapper toType(FieldMapper in) {
        return (TokenCountFieldMapper)in;
    }

    protected TokenCountFieldMapper(String simpleName, MappedFieldType defaultFieldType, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo, Builder builder) {
        super(simpleName, defaultFieldType, multiFields, copyTo);
        this.analyzer = builder.analyzer.getValue();
        this.enablePositionIncrements = builder.enablePositionIncrements.getValue();
        this.nullValue = builder.nullValue.getValue();
        this.index = builder.index.getValue();
        this.hasDocValues = builder.hasDocValues.getValue();
        this.store = builder.store.getValue();
    }

    @Override
    protected void parseCreateField(ParseContext context) throws IOException {
        String value = context.externalValueSet() ? context.externalValue().toString() : context.parser().textOrNull();
        if (value == null && this.nullValue == null) {
            return;
        }
        int tokenCount = value == null ? this.nullValue : TokenCountFieldMapper.countPositions((Analyzer)this.analyzer, this.name(), value, this.enablePositionIncrements);
        context.doc().addAll(NumberFieldMapper.NumberType.INTEGER.createFields(this.fieldType().name(), tokenCount, this.index, this.hasDocValues, this.store));
    }

    static int countPositions(Analyzer analyzer, String fieldName, String fieldValue, boolean enablePositionIncrements) throws IOException {
        try (TokenStream tokenStream = analyzer.tokenStream(fieldName, fieldValue);){
            int count = 0;
            PositionIncrementAttribute position = (PositionIncrementAttribute)tokenStream.addAttribute(PositionIncrementAttribute.class);
            tokenStream.reset();
            while (tokenStream.incrementToken()) {
                if (enablePositionIncrements) {
                    count += position.getPositionIncrement();
                    continue;
                }
                count += Math.min(1, position.getPositionIncrement());
            }
            tokenStream.end();
            if (enablePositionIncrements) {
                count += position.getPositionIncrement();
            }
            int n = count;
            return n;
        }
    }

    public String analyzer() {
        return this.analyzer.name();
    }

    public boolean enablePositionIncrements() {
        return this.enablePositionIncrements;
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    @Override
    public ParametrizedFieldMapper.Builder getMergeBuilder() {
        return new Builder(this.simpleName()).init(this);
    }

    public static class Builder
    extends ParametrizedFieldMapper.Builder {
        private final ParametrizedFieldMapper.Parameter<Boolean> index = ParametrizedFieldMapper.Parameter.indexParam(m -> TokenCountFieldMapper.toType((FieldMapper)m).index, true);
        private final ParametrizedFieldMapper.Parameter<Boolean> hasDocValues = ParametrizedFieldMapper.Parameter.docValuesParam(m -> TokenCountFieldMapper.toType((FieldMapper)m).hasDocValues, true);
        private final ParametrizedFieldMapper.Parameter<Boolean> store = ParametrizedFieldMapper.Parameter.storeParam(m -> TokenCountFieldMapper.toType((FieldMapper)m).store, false);
        private final ParametrizedFieldMapper.Parameter<NamedAnalyzer> analyzer = ParametrizedFieldMapper.Parameter.analyzerParam("analyzer", true, m -> TokenCountFieldMapper.toType((FieldMapper)m).analyzer, () -> null);
        private final ParametrizedFieldMapper.Parameter<Integer> nullValue = new ParametrizedFieldMapper.Parameter<Integer>("null_value", false, () -> null, (n, c, o) -> o == null ? null : Integer.valueOf(XContentMapValues.nodeIntegerValue(o)), m -> TokenCountFieldMapper.toType((FieldMapper)m).nullValue).acceptsNull();
        private final ParametrizedFieldMapper.Parameter<Boolean> enablePositionIncrements = ParametrizedFieldMapper.Parameter.boolParam("enable_position_increments", false, m -> TokenCountFieldMapper.toType((FieldMapper)m).enablePositionIncrements, true);
        private final ParametrizedFieldMapper.Parameter<Map<String, String>> meta = ParametrizedFieldMapper.Parameter.metaParam();

        public Builder(String name) {
            super(name);
        }

        @Override
        protected java.util.List<ParametrizedFieldMapper.Parameter<?>> getParameters() {
            return Arrays.asList(this.index, this.hasDocValues, this.store, this.analyzer, this.nullValue, this.enablePositionIncrements, this.meta);
        }

        @Override
        public TokenCountFieldMapper build(Mapper.BuilderContext context) {
            if (this.analyzer.getValue() == null) {
                throw new MapperParsingException("Analyzer must be set for field [" + this.name + "] but wasn't.");
            }
            TokenCountFieldType ft = new TokenCountFieldType(this.buildFullName(context), (boolean)this.index.getValue(), (boolean)this.store.getValue(), (boolean)this.hasDocValues.getValue(), this.nullValue.getValue(), this.meta.getValue());
            return new TokenCountFieldMapper(this.name, ft, this.multiFieldsBuilder.build(this, context), this.copyTo.build(), this);
        }
    }

    static class TokenCountFieldType
    extends NumberFieldMapper.NumberFieldType {
        TokenCountFieldType(String name, boolean isSearchable, boolean isStored, boolean hasDocValues, Number nullValue, Map<String, String> meta) {
            super(name, NumberFieldMapper.NumberType.INTEGER, isSearchable, isStored, hasDocValues, false, nullValue, meta);
        }

        @Override
        public ValueFetcher valueFetcher(MapperService mapperService, SearchLookup searchLookup, String format) {
            if (!this.hasDocValues()) {
                return lookup -> List.of();
            }
            return new DocValueFetcher(this.docValueFormat(format, null), searchLookup.doc().getForField(this));
        }
    }
}

