/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.index.mapper;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.exc.InputCoercionException;
import java.io.IOException;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.lucene.document.DoublePoint;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FloatPoint;
import org.apache.lucene.document.HalfFloatPoint;
import org.apache.lucene.document.IntPoint;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.document.SortedNumericDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.IndexOrDocValuesQuery;
import org.apache.lucene.search.IndexSortSortedNumericDocValuesRangeQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.NumericUtils;
import org.easysearch.common.Explicit;
import org.easysearch.common.Numbers;
import org.easysearch.common.lucene.Lucene;
import org.easysearch.common.lucene.search.Queries;
import org.easysearch.common.settings.Setting;
import org.easysearch.common.settings.Settings;
import org.easysearch.common.xcontent.XContentParser;
import org.easysearch.index.fielddata.IndexFieldData;
import org.easysearch.index.fielddata.IndexNumericFieldData;
import org.easysearch.index.fielddata.plain.SortedNumericIndexFieldData;
import org.easysearch.index.mapper.FieldMapper;
import org.easysearch.index.mapper.MappedFieldType;
import org.easysearch.index.mapper.Mapper;
import org.easysearch.index.mapper.MapperService;
import org.easysearch.index.mapper.ParametrizedFieldMapper;
import org.easysearch.index.mapper.ParseContext;
import org.easysearch.index.mapper.SimpleMappedFieldType;
import org.easysearch.index.mapper.SourceValueFetcher;
import org.easysearch.index.mapper.TextSearchInfo;
import org.easysearch.index.mapper.ValueFetcher;
import org.easysearch.index.query.QueryShardContext;
import org.easysearch.search.DocValueFormat;
import org.easysearch.search.lookup.SearchLookup;

public class NumberFieldMapper
extends ParametrizedFieldMapper {
    public static final Setting<Boolean> COERCE_SETTING = Setting.boolSetting("index.mapping.coerce", true, Setting.Property.IndexScope);
    private final NumberType type;
    private final boolean indexed;
    private final boolean hasDocValues;
    private final boolean stored;
    private final Explicit<Boolean> ignoreMalformed;
    private final Explicit<Boolean> coerce;
    private final Number nullValue;
    private final boolean ignoreMalformedByDefault;
    private final boolean coerceByDefault;

    private static NumberFieldMapper toType(FieldMapper in) {
        return (NumberFieldMapper)in;
    }

    private NumberFieldMapper(String simpleName, MappedFieldType mappedFieldType, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo, Builder builder) {
        super(simpleName, mappedFieldType, multiFields, copyTo);
        this.type = builder.type;
        this.indexed = builder.indexed.getValue();
        this.hasDocValues = builder.hasDocValues.getValue();
        this.stored = builder.stored.getValue();
        this.ignoreMalformed = builder.ignoreMalformed.getValue();
        this.coerce = builder.coerce.getValue();
        this.nullValue = builder.nullValue.getValue();
        this.ignoreMalformedByDefault = builder.ignoreMalformed.getDefaultValue().value();
        this.coerceByDefault = builder.coerce.getDefaultValue().value();
    }

    boolean coerce() {
        return this.coerce.value();
    }

    boolean ignoreMalformed() {
        return this.ignoreMalformed.value();
    }

    @Override
    public NumberFieldType fieldType() {
        return (NumberFieldType)super.fieldType();
    }

    @Override
    protected String contentType() {
        return this.fieldType().type.typeName();
    }

    @Override
    protected NumberFieldMapper clone() {
        return (NumberFieldMapper)super.clone();
    }

    @Override
    protected void parseCreateField(ParseContext context) throws IOException {
        Object value;
        XContentParser parser = context.parser();
        Number numericValue = null;
        if (context.externalValueSet()) {
            value = context.externalValue();
        } else if (parser.currentToken() == XContentParser.Token.VALUE_NULL) {
            value = null;
        } else if (this.coerce.value().booleanValue() && parser.currentToken() == XContentParser.Token.VALUE_STRING && parser.textLength() == 0) {
            value = null;
        } else {
            try {
                numericValue = this.fieldType().type.parse(parser, (boolean)this.coerce.value());
            }
            catch (JsonParseException | InputCoercionException | IllegalArgumentException e) {
                if (this.ignoreMalformed.value().booleanValue() && parser.currentToken().isValue()) {
                    context.addIgnoredField(this.mappedFieldType.name());
                    return;
                }
                throw e;
            }
            value = numericValue;
        }
        if (value == null) {
            value = this.nullValue;
        }
        if (value == null) {
            return;
        }
        if (numericValue == null) {
            numericValue = this.fieldType().type.parse(value, (boolean)this.coerce.value());
        }
        context.doc().addAll(this.fieldType().type.createFields(this.fieldType().name(), numericValue, this.indexed, this.hasDocValues, this.stored));
        if (!this.hasDocValues && (this.stored || this.indexed)) {
            this.createFieldNamesField(context);
        }
        context.postValue(this, null, value);
    }

    @Override
    public ParametrizedFieldMapper.Builder getMergeBuilder() {
        return new Builder(this.simpleName(), this.type, this.ignoreMalformedByDefault, this.coerceByDefault).init(this);
    }

    public static class Builder
    extends ParametrizedFieldMapper.Builder {
        private final ParametrizedFieldMapper.Parameter<Boolean> indexed = ParametrizedFieldMapper.Parameter.indexParam(m -> NumberFieldMapper.toType((FieldMapper)m).indexed, true);
        private final ParametrizedFieldMapper.Parameter<Boolean> hasDocValues = ParametrizedFieldMapper.Parameter.docValuesParam(m -> NumberFieldMapper.toType((FieldMapper)m).hasDocValues, true);
        private final ParametrizedFieldMapper.Parameter<Boolean> stored = ParametrizedFieldMapper.Parameter.storeParam(m -> NumberFieldMapper.toType((FieldMapper)m).stored, false);
        private final ParametrizedFieldMapper.Parameter<Explicit<Boolean>> ignoreMalformed;
        private final ParametrizedFieldMapper.Parameter<Explicit<Boolean>> coerce;
        private final ParametrizedFieldMapper.Parameter<Number> nullValue;
        private final ParametrizedFieldMapper.Parameter<Map<String, String>> meta = ParametrizedFieldMapper.Parameter.metaParam();
        private final NumberType type;

        public Builder(String name, NumberType type, Settings settings) {
            this(name, type, FieldMapper.IGNORE_MALFORMED_SETTING.get(settings), COERCE_SETTING.get(settings));
        }

        public static Builder docValuesOnly(String name, NumberType type) {
            Builder builder = new Builder(name, type, false, false);
            builder.indexed.setValue(false);
            return builder;
        }

        public Builder(String name, NumberType type, boolean ignoreMalformedByDefault, boolean coerceByDefault) {
            super(name);
            this.type = type;
            this.ignoreMalformed = ParametrizedFieldMapper.Parameter.explicitBoolParam("ignore_malformed", true, m -> NumberFieldMapper.toType((FieldMapper)m).ignoreMalformed, ignoreMalformedByDefault);
            this.coerce = ParametrizedFieldMapper.Parameter.explicitBoolParam("coerce", true, m -> NumberFieldMapper.toType((FieldMapper)m).coerce, coerceByDefault);
            this.nullValue = new ParametrizedFieldMapper.Parameter<Number>("null_value", false, () -> null, (n, c, o) -> o == null ? (Number)null : (Number)type.parse(o, false), m -> NumberFieldMapper.toType((FieldMapper)m).nullValue).acceptsNull();
        }

        Builder nullValue(Number number) {
            this.nullValue.setValue(number);
            return this;
        }

        public Builder docValues(boolean hasDocValues) {
            this.hasDocValues.setValue(hasDocValues);
            return this;
        }

        @Override
        protected List<ParametrizedFieldMapper.Parameter<?>> getParameters() {
            return Arrays.asList(this.indexed, this.hasDocValues, this.stored, this.ignoreMalformed, this.coerce, this.nullValue, this.meta);
        }

        @Override
        public NumberFieldMapper build(Mapper.BuilderContext context) {
            NumberFieldType ft = new NumberFieldType(this.buildFullName(context), this);
            return new NumberFieldMapper(this.name, ft, this.multiFieldsBuilder.build(this, context), this.copyTo.build(), this);
        }
    }

    public static enum NumberType {
        HALF_FLOAT("half_float", IndexNumericFieldData.NumericType.HALF_FLOAT){

            @Override
            public Float parse(Object value, boolean coerce) {
                float result;
                if (value instanceof Number) {
                    result = ((Number)value).floatValue();
                } else {
                    if (value instanceof BytesRef) {
                        value = ((BytesRef)value).utf8ToString();
                    }
                    result = Float.parseFloat(value.toString());
                }
                this.validateParsed(result);
                return Float.valueOf(result);
            }

            @Override
            public Number parsePoint(byte[] value) {
                return Float.valueOf(HalfFloatPoint.decodeDimension((byte[])value, (int)0));
            }

            @Override
            public Float parse(XContentParser parser, boolean coerce) throws IOException {
                float parsed = parser.floatValue(coerce);
                this.validateParsed(parsed);
                return Float.valueOf(parsed);
            }

            @Override
            public Query termQuery(String field, Object value) {
                float v = this.parse(value, false).floatValue();
                return HalfFloatPoint.newExactQuery((String)field, (float)v);
            }

            @Override
            public Query termsQuery(String field, List<Object> values) {
                float[] v = new float[values.size()];
                for (int i = 0; i < values.size(); ++i) {
                    v[i] = this.parse(values.get(i), false).floatValue();
                }
                return HalfFloatPoint.newSetQuery((String)field, (float[])v);
            }

            @Override
            public Query rangeQuery(String field, Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, boolean hasDocValues, QueryShardContext context) {
                float l = Float.NEGATIVE_INFINITY;
                float u = Float.POSITIVE_INFINITY;
                if (lowerTerm != null) {
                    l = this.parse(lowerTerm, false).floatValue();
                    if (includeLower) {
                        l = HalfFloatPoint.nextDown((float)l);
                    }
                    l = HalfFloatPoint.nextUp((float)l);
                }
                if (upperTerm != null) {
                    u = this.parse(upperTerm, false).floatValue();
                    if (includeUpper) {
                        u = HalfFloatPoint.nextUp((float)u);
                    }
                    u = HalfFloatPoint.nextDown((float)u);
                }
                Query query = HalfFloatPoint.newRangeQuery((String)field, (float)l, (float)u);
                if (hasDocValues) {
                    Query dvQuery = SortedNumericDocValuesField.newSlowRangeQuery((String)field, (long)HalfFloatPoint.halfFloatToSortableShort((float)l), (long)HalfFloatPoint.halfFloatToSortableShort((float)u));
                    query = new IndexOrDocValuesQuery(query, dvQuery);
                }
                return query;
            }

            @Override
            public List<Field> createFields(String name, Number value, boolean indexed, boolean docValued, boolean stored) {
                ArrayList<Field> fields = new ArrayList<Field>();
                if (indexed) {
                    fields.add((Field)new HalfFloatPoint(name, new float[]{value.floatValue()}));
                }
                if (docValued) {
                    fields.add((Field)new SortedNumericDocValuesField(name, (long)HalfFloatPoint.halfFloatToSortableShort((float)value.floatValue())));
                }
                if (stored) {
                    fields.add((Field)new StoredField(name, value.floatValue()));
                }
                return fields;
            }

            private void validateParsed(float value) {
                if (!Float.isFinite(HalfFloatPoint.sortableShortToHalfFloat((short)HalfFloatPoint.halfFloatToSortableShort((float)value)))) {
                    throw new IllegalArgumentException("[half_float] supports only finite values, but got [" + value + "]");
                }
            }
        }
        ,
        FLOAT("float", IndexNumericFieldData.NumericType.FLOAT){

            @Override
            public Float parse(Object value, boolean coerce) {
                float result;
                if (value instanceof Number) {
                    result = ((Number)value).floatValue();
                } else {
                    if (value instanceof BytesRef) {
                        value = ((BytesRef)value).utf8ToString();
                    }
                    result = Float.parseFloat(value.toString());
                }
                this.validateParsed(result);
                return Float.valueOf(result);
            }

            @Override
            public Number parsePoint(byte[] value) {
                return Float.valueOf(FloatPoint.decodeDimension((byte[])value, (int)0));
            }

            @Override
            public Float parse(XContentParser parser, boolean coerce) throws IOException {
                float parsed = parser.floatValue(coerce);
                this.validateParsed(parsed);
                return Float.valueOf(parsed);
            }

            @Override
            public Query termQuery(String field, Object value) {
                float v = this.parse(value, false).floatValue();
                return FloatPoint.newExactQuery((String)field, (float)v);
            }

            @Override
            public Query termsQuery(String field, List<Object> values) {
                float[] v = new float[values.size()];
                for (int i = 0; i < values.size(); ++i) {
                    v[i] = this.parse(values.get(i), false).floatValue();
                }
                return FloatPoint.newSetQuery((String)field, (float[])v);
            }

            @Override
            public Query rangeQuery(String field, Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, boolean hasDocValues, QueryShardContext context) {
                float l = Float.NEGATIVE_INFINITY;
                float u = Float.POSITIVE_INFINITY;
                if (lowerTerm != null) {
                    l = this.parse(lowerTerm, false).floatValue();
                    if (!includeLower) {
                        l = FloatPoint.nextUp((float)l);
                    }
                }
                if (upperTerm != null) {
                    u = this.parse(upperTerm, false).floatValue();
                    if (!includeUpper) {
                        u = FloatPoint.nextDown((float)u);
                    }
                }
                Query query = FloatPoint.newRangeQuery((String)field, (float)l, (float)u);
                if (hasDocValues) {
                    Query dvQuery = SortedNumericDocValuesField.newSlowRangeQuery((String)field, (long)NumericUtils.floatToSortableInt((float)l), (long)NumericUtils.floatToSortableInt((float)u));
                    query = new IndexOrDocValuesQuery(query, dvQuery);
                }
                return query;
            }

            @Override
            public List<Field> createFields(String name, Number value, boolean indexed, boolean docValued, boolean stored) {
                ArrayList<Field> fields = new ArrayList<Field>();
                if (indexed) {
                    fields.add((Field)new FloatPoint(name, new float[]{value.floatValue()}));
                }
                if (docValued) {
                    fields.add((Field)new SortedNumericDocValuesField(name, (long)NumericUtils.floatToSortableInt((float)value.floatValue())));
                }
                if (stored) {
                    fields.add((Field)new StoredField(name, value.floatValue()));
                }
                return fields;
            }

            private void validateParsed(float value) {
                if (!Float.isFinite(value)) {
                    throw new IllegalArgumentException("[float] supports only finite values, but got [" + value + "]");
                }
            }
        }
        ,
        DOUBLE("double", IndexNumericFieldData.NumericType.DOUBLE){

            @Override
            public Double parse(Object value, boolean coerce) {
                double parsed = 3.objectToDouble(value);
                this.validateParsed(parsed);
                return parsed;
            }

            @Override
            public Number parsePoint(byte[] value) {
                return DoublePoint.decodeDimension((byte[])value, (int)0);
            }

            @Override
            public Double parse(XContentParser parser, boolean coerce) throws IOException {
                double parsed = parser.doubleValue(coerce);
                this.validateParsed(parsed);
                return parsed;
            }

            @Override
            public Query termQuery(String field, Object value) {
                double v = this.parse(value, false);
                return DoublePoint.newExactQuery((String)field, (double)v);
            }

            @Override
            public Query termsQuery(String field, List<Object> values) {
                double[] v = new double[values.size()];
                for (int i = 0; i < values.size(); ++i) {
                    v[i] = this.parse(values.get(i), false);
                }
                return DoublePoint.newSetQuery((String)field, (double[])v);
            }

            @Override
            public Query rangeQuery(String field, Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, boolean hasDocValues, QueryShardContext context) {
                return 3.doubleRangeQuery(lowerTerm, upperTerm, includeLower, includeUpper, (l, u) -> {
                    Query query = DoublePoint.newRangeQuery((String)field, (double)l, (double)u);
                    if (hasDocValues) {
                        Query dvQuery = SortedNumericDocValuesField.newSlowRangeQuery((String)field, (long)NumericUtils.doubleToSortableLong((double)l), (long)NumericUtils.doubleToSortableLong((double)u));
                        query = new IndexOrDocValuesQuery(query, dvQuery);
                    }
                    return query;
                });
            }

            @Override
            public List<Field> createFields(String name, Number value, boolean indexed, boolean docValued, boolean stored) {
                ArrayList<Field> fields = new ArrayList<Field>();
                if (indexed) {
                    fields.add((Field)new DoublePoint(name, new double[]{value.doubleValue()}));
                }
                if (docValued) {
                    fields.add((Field)new SortedNumericDocValuesField(name, NumericUtils.doubleToSortableLong((double)value.doubleValue())));
                }
                if (stored) {
                    fields.add((Field)new StoredField(name, value.doubleValue()));
                }
                return fields;
            }

            private void validateParsed(double value) {
                if (!Double.isFinite(value)) {
                    throw new IllegalArgumentException("[double] supports only finite values, but got [" + value + "]");
                }
            }
        }
        ,
        BYTE("byte", IndexNumericFieldData.NumericType.BYTE){

            @Override
            public Byte parse(Object value, boolean coerce) {
                double doubleValue = 4.objectToDouble(value);
                if (doubleValue < -128.0 || doubleValue > 127.0) {
                    throw new IllegalArgumentException("Value [" + value + "] is out of range for a byte");
                }
                if (!coerce && doubleValue % 1.0 != 0.0) {
                    throw new IllegalArgumentException("Value [" + value + "] has a decimal part");
                }
                if (value instanceof Number) {
                    return ((Number)value).byteValue();
                }
                return (byte)doubleValue;
            }

            @Override
            public Number parsePoint(byte[] value) {
                return INTEGER.parsePoint(value).byteValue();
            }

            @Override
            public Short parse(XContentParser parser, boolean coerce) throws IOException {
                int value = parser.intValue(coerce);
                if (value < -128 || value > 127) {
                    throw new IllegalArgumentException("Value [" + value + "] is out of range for a byte");
                }
                return (short)value;
            }

            @Override
            public Query termQuery(String field, Object value) {
                return INTEGER.termQuery(field, value);
            }

            @Override
            public Query termsQuery(String field, List<Object> values) {
                return INTEGER.termsQuery(field, values);
            }

            @Override
            public Query rangeQuery(String field, Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, boolean hasDocValues, QueryShardContext context) {
                return INTEGER.rangeQuery(field, lowerTerm, upperTerm, includeLower, includeUpper, hasDocValues, context);
            }

            @Override
            public List<Field> createFields(String name, Number value, boolean indexed, boolean docValued, boolean stored) {
                return INTEGER.createFields(name, value, indexed, docValued, stored);
            }

            @Override
            Number valueForSearch(Number value) {
                return value.byteValue();
            }
        }
        ,
        SHORT("short", IndexNumericFieldData.NumericType.SHORT){

            @Override
            public Short parse(Object value, boolean coerce) {
                double doubleValue = 5.objectToDouble(value);
                if (doubleValue < -32768.0 || doubleValue > 32767.0) {
                    throw new IllegalArgumentException("Value [" + value + "] is out of range for a short");
                }
                if (!coerce && doubleValue % 1.0 != 0.0) {
                    throw new IllegalArgumentException("Value [" + value + "] has a decimal part");
                }
                if (value instanceof Number) {
                    return ((Number)value).shortValue();
                }
                return (short)doubleValue;
            }

            @Override
            public Number parsePoint(byte[] value) {
                return INTEGER.parsePoint(value).shortValue();
            }

            @Override
            public Short parse(XContentParser parser, boolean coerce) throws IOException {
                return parser.shortValue(coerce);
            }

            @Override
            public Query termQuery(String field, Object value) {
                return INTEGER.termQuery(field, value);
            }

            @Override
            public Query termsQuery(String field, List<Object> values) {
                return INTEGER.termsQuery(field, values);
            }

            @Override
            public Query rangeQuery(String field, Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, boolean hasDocValues, QueryShardContext context) {
                return INTEGER.rangeQuery(field, lowerTerm, upperTerm, includeLower, includeUpper, hasDocValues, context);
            }

            @Override
            public List<Field> createFields(String name, Number value, boolean indexed, boolean docValued, boolean stored) {
                return INTEGER.createFields(name, value, indexed, docValued, stored);
            }

            @Override
            Number valueForSearch(Number value) {
                return value.shortValue();
            }
        }
        ,
        INTEGER("integer", IndexNumericFieldData.NumericType.INT){

            @Override
            public Integer parse(Object value, boolean coerce) {
                double doubleValue = 6.objectToDouble(value);
                if (doubleValue < -2.147483648E9 || doubleValue > 2.147483647E9) {
                    throw new IllegalArgumentException("Value [" + value + "] is out of range for an integer");
                }
                if (!coerce && doubleValue % 1.0 != 0.0) {
                    throw new IllegalArgumentException("Value [" + value + "] has a decimal part");
                }
                if (value instanceof Number) {
                    return ((Number)value).intValue();
                }
                return (int)doubleValue;
            }

            @Override
            public Number parsePoint(byte[] value) {
                return IntPoint.decodeDimension((byte[])value, (int)0);
            }

            @Override
            public Integer parse(XContentParser parser, boolean coerce) throws IOException {
                return parser.intValue(coerce);
            }

            @Override
            public Query termQuery(String field, Object value) {
                if (6.hasDecimalPart(value)) {
                    return Queries.newMatchNoDocsQuery("Value [" + value + "] has a decimal part");
                }
                int v = this.parse(value, true);
                return IntPoint.newExactQuery((String)field, (int)v);
            }

            @Override
            public Query termsQuery(String field, List<Object> values) {
                int[] v = new int[values.size()];
                int upTo = 0;
                for (int i = 0; i < values.size(); ++i) {
                    Object value = values.get(i);
                    if (6.hasDecimalPart(value)) continue;
                    v[upTo++] = this.parse(value, true);
                }
                if (upTo == 0) {
                    return Queries.newMatchNoDocsQuery("All values have a decimal part");
                }
                if (upTo != v.length) {
                    v = Arrays.copyOf(v, upTo);
                }
                return IntPoint.newSetQuery((String)field, (int[])v);
            }

            @Override
            public Query rangeQuery(String field, Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, boolean hasDocValues, QueryShardContext context) {
                int l = Integer.MIN_VALUE;
                int u = Integer.MAX_VALUE;
                if (lowerTerm != null) {
                    l = this.parse(lowerTerm, true);
                    boolean lowerTermHasDecimalPart = 6.hasDecimalPart(lowerTerm);
                    if (!lowerTermHasDecimalPart && !includeLower || lowerTermHasDecimalPart && 6.signum(lowerTerm) > 0.0) {
                        if (l == Integer.MAX_VALUE) {
                            return new MatchNoDocsQuery();
                        }
                        ++l;
                    }
                }
                if (upperTerm != null) {
                    u = this.parse(upperTerm, true);
                    boolean upperTermHasDecimalPart = 6.hasDecimalPart(upperTerm);
                    if (!upperTermHasDecimalPart && !includeUpper || upperTermHasDecimalPart && 6.signum(upperTerm) < 0.0) {
                        if (u == Integer.MIN_VALUE) {
                            return new MatchNoDocsQuery();
                        }
                        --u;
                    }
                }
                Query query = IntPoint.newRangeQuery((String)field, (int)l, (int)u);
                if (hasDocValues) {
                    Query dvQuery = SortedNumericDocValuesField.newSlowRangeQuery((String)field, (long)l, (long)u);
                    query = new IndexOrDocValuesQuery(query, dvQuery);
                    if (context.indexSortedOnField(field)) {
                        query = new IndexSortSortedNumericDocValuesRangeQuery(field, (long)l, (long)u, query);
                    }
                }
                return query;
            }

            @Override
            public List<Field> createFields(String name, Number value, boolean indexed, boolean docValued, boolean stored) {
                ArrayList<Field> fields = new ArrayList<Field>();
                if (indexed) {
                    fields.add((Field)new IntPoint(name, new int[]{value.intValue()}));
                }
                if (docValued) {
                    fields.add((Field)new SortedNumericDocValuesField(name, (long)value.intValue()));
                }
                if (stored) {
                    fields.add((Field)new StoredField(name, value.intValue()));
                }
                return fields;
            }
        }
        ,
        LONG("long", IndexNumericFieldData.NumericType.LONG){

            @Override
            public Long parse(Object value, boolean coerce) {
                return 7.objectToLong(value, coerce);
            }

            @Override
            public Number parsePoint(byte[] value) {
                return LongPoint.decodeDimension((byte[])value, (int)0);
            }

            @Override
            public Long parse(XContentParser parser, boolean coerce) throws IOException {
                return parser.longValue(coerce);
            }

            @Override
            public Query termQuery(String field, Object value) {
                if (7.hasDecimalPart(value)) {
                    return Queries.newMatchNoDocsQuery("Value [" + value + "] has a decimal part");
                }
                long v = this.parse(value, true);
                return LongPoint.newExactQuery((String)field, (long)v);
            }

            @Override
            public Query termsQuery(String field, List<Object> values) {
                long[] v = new long[values.size()];
                int upTo = 0;
                for (int i = 0; i < values.size(); ++i) {
                    Object value = values.get(i);
                    if (7.hasDecimalPart(value)) continue;
                    v[upTo++] = this.parse(value, true);
                }
                if (upTo == 0) {
                    return Queries.newMatchNoDocsQuery("All values have a decimal part");
                }
                if (upTo != v.length) {
                    v = Arrays.copyOf(v, upTo);
                }
                return LongPoint.newSetQuery((String)field, (long[])v);
            }

            @Override
            public Query rangeQuery(String field, Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, boolean hasDocValues, QueryShardContext context) {
                return 7.longRangeQuery(lowerTerm, upperTerm, includeLower, includeUpper, (l, u) -> {
                    Query query = LongPoint.newRangeQuery((String)field, (long)l, (long)u);
                    if (hasDocValues) {
                        Query dvQuery = SortedNumericDocValuesField.newSlowRangeQuery((String)field, (long)l, (long)u);
                        query = new IndexOrDocValuesQuery(query, dvQuery);
                        if (context.indexSortedOnField(field)) {
                            query = new IndexSortSortedNumericDocValuesRangeQuery(field, l.longValue(), u.longValue(), query);
                        }
                    }
                    return query;
                });
            }

            @Override
            public List<Field> createFields(String name, Number value, boolean indexed, boolean docValued, boolean stored) {
                ArrayList<Field> fields = new ArrayList<Field>();
                if (indexed) {
                    fields.add((Field)new LongPoint(name, new long[]{value.longValue()}));
                }
                if (docValued) {
                    fields.add((Field)new SortedNumericDocValuesField(name, value.longValue()));
                }
                if (stored) {
                    fields.add((Field)new StoredField(name, value.longValue()));
                }
                return fields;
            }
        };

        private final String name;
        private final IndexNumericFieldData.NumericType numericType;
        private final ParametrizedFieldMapper.TypeParser parser;

        private NumberType(String name, IndexNumericFieldData.NumericType numericType) {
            this.name = name;
            this.numericType = numericType;
            this.parser = new ParametrizedFieldMapper.TypeParser((n, c) -> new Builder((String)n, this, c.getSettings()));
        }

        public final String typeName() {
            return this.name;
        }

        public final IndexNumericFieldData.NumericType numericType() {
            return this.numericType;
        }

        public final ParametrizedFieldMapper.TypeParser parser() {
            return this.parser;
        }

        public abstract Query termQuery(String var1, Object var2);

        public abstract Query termsQuery(String var1, List<Object> var2);

        public abstract Query rangeQuery(String var1, Object var2, Object var3, boolean var4, boolean var5, boolean var6, QueryShardContext var7);

        public abstract Number parse(XContentParser var1, boolean var2) throws IOException;

        public abstract Number parse(Object var1, boolean var2);

        public abstract Number parsePoint(byte[] var1);

        public abstract List<Field> createFields(String var1, Number var2, boolean var3, boolean var4, boolean var5);

        Number valueForSearch(Number value) {
            return value;
        }

        public static boolean hasDecimalPart(Object number) {
            if (number instanceof Number) {
                double doubleValue = ((Number)number).doubleValue();
                return doubleValue % 1.0 != 0.0;
            }
            if (number instanceof BytesRef) {
                number = ((BytesRef)number).utf8ToString();
            }
            if (number instanceof String) {
                return Double.parseDouble((String)number) % 1.0 != 0.0;
            }
            return false;
        }

        static double signum(Object value) {
            if (value instanceof Number) {
                double doubleValue = ((Number)value).doubleValue();
                return Math.signum(doubleValue);
            }
            if (value instanceof BytesRef) {
                value = ((BytesRef)value).utf8ToString();
            }
            return Math.signum(Double.parseDouble(value.toString()));
        }

        public static double objectToDouble(Object value) {
            double doubleValue = value instanceof Number ? ((Number)value).doubleValue() : (value instanceof BytesRef ? Double.parseDouble(((BytesRef)value).utf8ToString()) : Double.parseDouble(value.toString()));
            return doubleValue;
        }

        public static long objectToLong(Object value, boolean coerce) {
            if (value instanceof Long) {
                return (Long)value;
            }
            double doubleValue = NumberType.objectToDouble(value);
            if (doubleValue < -9.223372036854776E18 || doubleValue > 9.223372036854776E18) {
                throw new IllegalArgumentException("Value [" + value + "] is out of range for a long");
            }
            if (!coerce && doubleValue % 1.0 != 0.0) {
                throw new IllegalArgumentException("Value [" + value + "] has a decimal part");
            }
            String stringValue = value instanceof BytesRef ? ((BytesRef)value).utf8ToString() : value.toString();
            return Numbers.toLong(stringValue, coerce);
        }

        public static Query doubleRangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, BiFunction<Double, Double, Query> builder) {
            double l = Double.NEGATIVE_INFINITY;
            double u = Double.POSITIVE_INFINITY;
            if (lowerTerm != null) {
                l = NumberType.objectToDouble(lowerTerm);
                if (!includeLower) {
                    l = DoublePoint.nextUp((double)l);
                }
            }
            if (upperTerm != null) {
                u = NumberType.objectToDouble(upperTerm);
                if (!includeUpper) {
                    u = DoublePoint.nextDown((double)u);
                }
            }
            return builder.apply(l, u);
        }

        public static Query longRangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, BiFunction<Long, Long, Query> builder) {
            long l = Long.MIN_VALUE;
            long u = Long.MAX_VALUE;
            if (lowerTerm != null) {
                l = NumberType.objectToLong(lowerTerm, true);
                boolean lowerTermHasDecimalPart = NumberType.hasDecimalPart(lowerTerm);
                if (!lowerTermHasDecimalPart && !includeLower || lowerTermHasDecimalPart && NumberType.signum(lowerTerm) > 0.0) {
                    if (l == Long.MAX_VALUE) {
                        return new MatchNoDocsQuery();
                    }
                    ++l;
                }
            }
            if (upperTerm != null) {
                u = NumberType.objectToLong(upperTerm, true);
                boolean upperTermHasDecimalPart = NumberType.hasDecimalPart(upperTerm);
                if (!upperTermHasDecimalPart && !includeUpper || upperTermHasDecimalPart && NumberType.signum(upperTerm) < 0.0) {
                    if (u == Long.MIN_VALUE) {
                        return new MatchNoDocsQuery();
                    }
                    --u;
                }
            }
            return builder.apply(l, u);
        }
    }

    public static class NumberFieldType
    extends SimpleMappedFieldType {
        private final NumberType type;
        private final boolean coerce;
        private final Number nullValue;

        public NumberFieldType(String name, NumberType type, boolean isSearchable, boolean isStored, boolean hasDocValues, boolean coerce, Number nullValue, Map<String, String> meta) {
            super(name, isSearchable, isStored, hasDocValues, TextSearchInfo.SIMPLE_MATCH_ONLY, meta);
            this.type = Objects.requireNonNull(type);
            this.coerce = coerce;
            this.nullValue = nullValue;
            this.setIndexAnalyzer(Lucene.KEYWORD_ANALYZER);
        }

        NumberFieldType(String name, Builder builder) {
            this(name, builder.type, builder.indexed.getValue(), builder.stored.getValue(), builder.hasDocValues.getValue(), builder.coerce.getValue().value(), builder.nullValue.getValue(), builder.meta.getValue());
        }

        public NumberFieldType(String name, NumberType type) {
            this(name, type, true, false, true, true, null, Collections.emptyMap());
        }

        @Override
        public String typeName() {
            return this.type.name;
        }

        public IndexNumericFieldData.NumericType numericType() {
            return this.type.numericType();
        }

        @Override
        public Query termQuery(Object value, QueryShardContext context) {
            this.failIfNotIndexed();
            Query query = this.type.termQuery(this.name(), value);
            if (this.boost() != 1.0f) {
                query = new BoostQuery(query, this.boost());
            }
            return query;
        }

        public Query termsQuery(List values, QueryShardContext context) {
            this.failIfNotIndexed();
            Query query = this.type.termsQuery(this.name(), values);
            if (this.boost() != 1.0f) {
                query = new BoostQuery(query, this.boost());
            }
            return query;
        }

        @Override
        public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, QueryShardContext context) {
            this.failIfNotIndexed();
            Query query = this.type.rangeQuery(this.name(), lowerTerm, upperTerm, includeLower, includeUpper, this.hasDocValues(), context);
            if (this.boost() != 1.0f) {
                query = new BoostQuery(query, this.boost());
            }
            return query;
        }

        @Override
        public Function<byte[], Number> pointReaderIfPossible() {
            if (this.isSearchable()) {
                return this::parsePoint;
            }
            return null;
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName, Supplier<SearchLookup> searchLookup) {
            this.failIfNoDocValues();
            return new SortedNumericIndexFieldData.Builder(this.name(), this.type.numericType());
        }

        @Override
        public Object valueForDisplay(Object value) {
            if (value == null) {
                return null;
            }
            return this.type.valueForSearch((Number)value);
        }

        @Override
        public ValueFetcher valueFetcher(MapperService mapperService, SearchLookup searchLookup, String format) {
            if (format != null) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] doesn't support formats.");
            }
            return new SourceValueFetcher(this.name(), mapperService, this.nullValue){

                @Override
                protected Object parseSourceValue(Object value) {
                    if (value.equals("")) {
                        return nullValue;
                    }
                    return type.parse(value, coerce);
                }
            };
        }

        @Override
        public DocValueFormat docValueFormat(String format, ZoneId timeZone) {
            if (timeZone != null) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] does not support custom time zones");
            }
            if (format == null) {
                return DocValueFormat.RAW;
            }
            return new DocValueFormat.Decimal(format);
        }

        public Number parsePoint(byte[] value) {
            return this.type.parsePoint(value);
        }
    }
}

