/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.index.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.BytesRef;
import org.easysearch.EasysearchGenerationException;
import org.easysearch.Version;
import org.easysearch.common.bytes.BytesArray;
import org.easysearch.common.compress.CompressedXContent;
import org.easysearch.common.settings.Settings;
import org.easysearch.common.text.Text;
import org.easysearch.common.xcontent.ToXContent;
import org.easysearch.common.xcontent.ToXContentFragment;
import org.easysearch.common.xcontent.XContentBuilder;
import org.easysearch.common.xcontent.XContentType;
import org.easysearch.index.IndexSettings;
import org.easysearch.index.analysis.IndexAnalyzers;
import org.easysearch.index.mapper.ContentPath;
import org.easysearch.index.mapper.DocumentParser;
import org.easysearch.index.mapper.FieldTypeLookup;
import org.easysearch.index.mapper.IdFieldMapper;
import org.easysearch.index.mapper.IndexFieldMapper;
import org.easysearch.index.mapper.Mapper;
import org.easysearch.index.mapper.MapperParsingException;
import org.easysearch.index.mapper.MapperService;
import org.easysearch.index.mapper.Mapping;
import org.easysearch.index.mapper.MappingLookup;
import org.easysearch.index.mapper.MetadataFieldMapper;
import org.easysearch.index.mapper.ObjectMapper;
import org.easysearch.index.mapper.ParseContext;
import org.easysearch.index.mapper.ParsedDocument;
import org.easysearch.index.mapper.RootObjectMapper;
import org.easysearch.index.mapper.RoutingFieldMapper;
import org.easysearch.index.mapper.SourceFieldMapper;
import org.easysearch.index.mapper.SourceToParse;
import org.easysearch.index.mapper.TypeFieldMapper;
import org.easysearch.search.internal.SearchContext;

public class DocumentMapper
implements ToXContentFragment {
    private final MapperService mapperService;
    private final String type;
    private final Text typeText;
    private final CompressedXContent mappingSource;
    private final Mapping mapping;
    private final DocumentParser documentParser;
    private final MappingLookup fieldMappers;
    private final MetadataFieldMapper[] deleteTombstoneMetadataFieldMappers;
    private final MetadataFieldMapper[] noopTombstoneMetadataFieldMappers;

    public DocumentMapper(MapperService mapperService, Mapping mapping) {
        this.mapperService = mapperService;
        this.type = mapping.root().name();
        this.typeText = new Text(this.type);
        IndexSettings indexSettings = mapperService.getIndexSettings();
        this.mapping = mapping;
        this.documentParser = new DocumentParser(indexSettings, mapperService.documentMapperParser(), this);
        IndexAnalyzers indexAnalyzers = mapperService.getIndexAnalyzers();
        this.fieldMappers = MappingLookup.fromMapping(this.mapping, (Analyzer)indexAnalyzers.getDefaultIndexAnalyzer());
        try {
            this.mappingSource = new CompressedXContent(this, XContentType.JSON, ToXContent.EMPTY_PARAMS);
        }
        catch (Exception e) {
            throw new EasysearchGenerationException("failed to serialize source for type [" + this.type + "]", e);
        }
        List<String> deleteTombstoneMetadataFields = Arrays.asList("_version", "_id", "_type", "_seq_no", "_primary_term", "_tombstone");
        this.deleteTombstoneMetadataFieldMappers = (MetadataFieldMapper[])Stream.of(mapping.metadataMappers).filter(field -> deleteTombstoneMetadataFields.contains(field.name())).toArray(MetadataFieldMapper[]::new);
        List<String> noopTombstoneMetadataFields = Arrays.asList("_version", "_seq_no", "_primary_term", "_tombstone");
        this.noopTombstoneMetadataFieldMappers = (MetadataFieldMapper[])Stream.of(mapping.metadataMappers).filter(field -> noopTombstoneMetadataFields.contains(field.name())).toArray(MetadataFieldMapper[]::new);
    }

    public Mapping mapping() {
        return this.mapping;
    }

    public String type() {
        return this.type;
    }

    public Text typeText() {
        return this.typeText;
    }

    public Map<String, Object> meta() {
        return this.mapping.meta;
    }

    public CompressedXContent mappingSource() {
        return this.mappingSource;
    }

    public RootObjectMapper root() {
        return this.mapping.root;
    }

    public <T extends MetadataFieldMapper> T metadataMapper(Class<T> type) {
        return this.mapping.metadataMapper(type);
    }

    public IndexFieldMapper indexMapper() {
        return this.metadataMapper(IndexFieldMapper.class);
    }

    public TypeFieldMapper typeMapper() {
        return this.metadataMapper(TypeFieldMapper.class);
    }

    public SourceFieldMapper sourceMapper() {
        return this.metadataMapper(SourceFieldMapper.class);
    }

    public IdFieldMapper idFieldMapper() {
        return this.metadataMapper(IdFieldMapper.class);
    }

    public RoutingFieldMapper routingFieldMapper() {
        return this.metadataMapper(RoutingFieldMapper.class);
    }

    public IndexFieldMapper IndexFieldMapper() {
        return this.metadataMapper(IndexFieldMapper.class);
    }

    public boolean hasNestedObjects() {
        return this.mappers().hasNested();
    }

    public MappingLookup mappers() {
        return this.fieldMappers;
    }

    public FieldTypeLookup fieldTypes() {
        return this.mappers().fieldTypes();
    }

    public Map<String, ObjectMapper> objectMappers() {
        return this.mappers().objectMappers();
    }

    public ParsedDocument parse(SourceToParse source) throws MapperParsingException {
        return this.documentParser.parseDocument(source, this.mapping.metadataMappers);
    }

    public ParsedDocument createDeleteTombstoneDoc(String index, String type, String id) throws MapperParsingException {
        SourceToParse emptySource = new SourceToParse(index, type, id, new BytesArray("{}"), XContentType.JSON);
        return this.documentParser.parseDocument(emptySource, this.deleteTombstoneMetadataFieldMappers).toTombstone();
    }

    public ParsedDocument createNoopTombstoneDoc(String index, String reason) throws MapperParsingException {
        String id = "";
        SourceToParse sourceToParse = new SourceToParse(index, this.type, "", new BytesArray("{}"), XContentType.JSON);
        ParsedDocument parsedDoc = this.documentParser.parseDocument(sourceToParse, this.noopTombstoneMetadataFieldMappers).toTombstone();
        BytesRef byteRef = new BytesRef((CharSequence)reason);
        parsedDoc.rootDoc().add((IndexableField)new StoredField("_source", byteRef.bytes, byteRef.offset, byteRef.length));
        return parsedDoc;
    }

    public ObjectMapper findNestedObjectMapper(int nestedDocId, SearchContext sc, LeafReaderContext context) throws IOException {
        ObjectMapper nestedObjectMapper = null;
        for (ObjectMapper objectMapper : this.objectMappers().values()) {
            Weight nestedWeight;
            Scorer scorer;
            Query filter;
            if (!objectMapper.nested().isNested() || (filter = objectMapper.nestedTypeFilter()) == null || (scorer = (nestedWeight = filter.createWeight((IndexSearcher)sc.searcher(), ScoreMode.COMPLETE_NO_SCORES, 1.0f)).scorer(context)) == null || scorer.iterator().advance(nestedDocId) != nestedDocId) continue;
            if (nestedObjectMapper == null) {
                nestedObjectMapper = objectMapper;
                continue;
            }
            if (nestedObjectMapper.fullPath().length() >= objectMapper.fullPath().length()) continue;
            nestedObjectMapper = objectMapper;
        }
        return nestedObjectMapper;
    }

    public DocumentMapper merge(Mapping mapping, MapperService.MergeReason reason) {
        Mapping merged = this.mapping.merge(mapping, reason);
        return new DocumentMapper(this.mapperService, merged);
    }

    public void validate(IndexSettings settings, boolean checkLimits) {
        this.mapping.validate(this.fieldMappers);
        if (settings.getIndexMetadata().isRoutingPartitionedIndex() && !this.routingFieldMapper().required()) {
            throw new IllegalArgumentException("mapping type [" + this.type() + "] must have routing required for partitioned index [" + settings.getIndex().getName() + "]");
        }
        if (settings.getIndexSortConfig().hasIndexSort() && this.hasNestedObjects()) {
            throw new IllegalArgumentException("cannot have nested fields when index sort is activated");
        }
        if (checkLimits) {
            this.fieldMappers.checkLimits(settings);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return this.mapping.toXContent(builder, params);
    }

    public void addSkipPath(String path, ParseContext context) {
        boolean isReuse = this.mapperService.isReuse();
        if (isReuse) {
            Map<String, List<String>> map = this.getSkipPaths();
            Objects.requireNonNull(map);
            if (!map.containsKey(path)) {
                boolean contains = false;
                for (String s : map.keySet()) {
                    if (!path.startsWith(s)) continue;
                    contains = true;
                    break;
                }
                if (!contains) {
                    map.put(path, DocumentMapper.splitByDot(path));
                    ((ParseContext.InternalParseContext)context).metaUpdated = true;
                }
            }
        }
    }

    public static List<String> splitByDot(String str) {
        int dotIndex;
        ArrayList<String> parts = new ArrayList<String>();
        int startIndex = 0;
        while ((dotIndex = str.indexOf(46, startIndex)) != -1) {
            parts.add(str.substring(startIndex, dotIndex));
            startIndex = dotIndex + 1;
        }
        parts.add(str.substring(startIndex));
        return parts;
    }

    public Map<String, List<String>> getSkipPaths() {
        Map map = (Map)this.meta().get("skip");
        return map;
    }

    public String toString() {
        return "DocumentMapper{mapperService=" + this.mapperService + ", type='" + this.type + "', typeText=" + this.typeText + ", mappingSource=" + this.mappingSource + ", mapping=" + this.mapping + ", documentParser=" + this.documentParser + ", fieldMappers=" + this.fieldMappers + ", objectMappers=" + this.objectMappers() + ", hasNestedObjects=" + this.hasNestedObjects() + ", deleteTombstoneMetadataFieldMappers=" + Arrays.toString(this.deleteTombstoneMetadataFieldMappers) + ", noopTombstoneMetadataFieldMappers=" + Arrays.toString(this.noopTombstoneMetadataFieldMappers) + "}";
    }

    public static class Builder {
        private final Map<Class<? extends MetadataFieldMapper>, MetadataFieldMapper> metadataMappers = new LinkedHashMap<Class<? extends MetadataFieldMapper>, MetadataFieldMapper>();
        private final RootObjectMapper rootObjectMapper;
        private Map<String, Object> meta;
        private final Mapper.BuilderContext builderContext;

        public Builder(RootObjectMapper.Builder builder, MapperService mapperService) {
            Settings indexSettings = mapperService.getIndexSettings().getSettings();
            this.builderContext = new Mapper.BuilderContext(indexSettings, new ContentPath(1));
            this.rootObjectMapper = builder.build(this.builderContext);
            String type = this.rootObjectMapper.name();
            DocumentMapper existingMapper = mapperService.documentMapper(type);
            Version indexCreatedVersion = mapperService.getIndexSettings().getIndexVersionCreated();
            Map<String, MetadataFieldMapper.TypeParser> metadataMapperParsers = mapperService.mapperRegistry.getMetadataMapperParsers(indexCreatedVersion);
            for (Map.Entry<String, MetadataFieldMapper.TypeParser> entry : metadataMapperParsers.entrySet()) {
                MetadataFieldMapper metadataMapper;
                MetadataFieldMapper existingMetadataMapper;
                String name = entry.getKey();
                MetadataFieldMapper metadataFieldMapper = existingMetadataMapper = existingMapper == null ? null : (MetadataFieldMapper)existingMapper.mappers().getMapper(name);
                if (existingMetadataMapper == null) {
                    MetadataFieldMapper.TypeParser parser = entry.getValue();
                    metadataMapper = parser.getDefault(mapperService.fieldType(name), mapperService.documentMapperParser().parserContext());
                } else {
                    metadataMapper = existingMetadataMapper;
                }
                this.metadataMappers.put(metadataMapper.getClass(), metadataMapper);
            }
        }

        public Builder meta(Map<String, Object> meta) {
            this.meta = meta;
            return this;
        }

        public Builder put(MetadataFieldMapper.Builder mapper) {
            MetadataFieldMapper metadataMapper = mapper.build(this.builderContext);
            this.metadataMappers.put(metadataMapper.getClass(), metadataMapper);
            return this;
        }

        public DocumentMapper build(MapperService mapperService) {
            Objects.requireNonNull(this.rootObjectMapper, "Mapper builder must have the root object mapper set");
            Mapping mapping = new Mapping(mapperService.getIndexSettings().getIndexVersionCreated(), this.rootObjectMapper, this.metadataMappers.values().toArray(new MetadataFieldMapper[0]), this.meta);
            return new DocumentMapper(mapperService, mapping);
        }
    }
}

