/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.index.mapper;

import java.util.Collections;
import java.util.List;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.easysearch.common.Explicit;
import org.easysearch.index.mapper.FieldMapper;
import org.easysearch.index.mapper.Mapper;
import org.easysearch.index.mapper.MapperService;
import org.easysearch.index.mapper.MetadataFieldMapper;
import org.easysearch.index.mapper.ParametrizedFieldMapper;
import org.easysearch.index.mapper.StringFieldType;
import org.easysearch.index.mapper.TextSearchInfo;
import org.easysearch.index.mapper.ValueFetcher;
import org.easysearch.index.query.QueryShardContext;
import org.easysearch.search.lookup.SearchLookup;

public class AllFieldMapper
extends MetadataFieldMapper {
    public static final String NAME = "_all";
    public static final String CONTENT_TYPE = "_all";
    public static final MetadataFieldMapper.TypeParser PARSER = new MetadataFieldMapper.ConfigurableTypeParser(c -> new AllFieldMapper(new Explicit<Boolean>(false, false)), c -> new Builder());
    private final Explicit<Boolean> enabled;

    private static AllFieldMapper toType(FieldMapper in) {
        return (AllFieldMapper)in;
    }

    private AllFieldMapper(Explicit<Boolean> enabled) {
        super(new AllFieldType());
        this.enabled = enabled;
    }

    @Override
    protected String contentType() {
        return "_all";
    }

    @Override
    public ParametrizedFieldMapper.Builder getMergeBuilder() {
        return new Builder().init(this);
    }

    static final class AllFieldType
    extends StringFieldType {
        AllFieldType() {
            super("_all", false, false, false, TextSearchInfo.NONE, Collections.emptyMap());
        }

        @Override
        public ValueFetcher valueFetcher(MapperService mapperService, SearchLookup searchLookup, String format) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String typeName() {
            return "_all";
        }

        @Override
        public Query existsQuery(QueryShardContext context) {
            return new MatchNoDocsQuery();
        }
    }

    public static class Builder
    extends MetadataFieldMapper.Builder {
        private final ParametrizedFieldMapper.Parameter<Explicit<Boolean>> enabled = MetadataFieldMapper.updateableBoolParam("enabled", m -> AllFieldMapper.toType((FieldMapper)m).enabled, false);

        public Builder() {
            super("_all");
        }

        @Override
        protected List<ParametrizedFieldMapper.Parameter<?>> getParameters() {
            return Collections.singletonList(this.enabled);
        }

        @Override
        public AllFieldMapper build(Mapper.BuilderContext context) {
            if (this.enabled.getValue().value().booleanValue()) {
                throw new IllegalArgumentException("[_all] is disabled in this version.");
            }
            return new AllFieldMapper(this.enabled.getValue());
        }
    }

    public static class Defaults {
        public static final FieldType FIELD_TYPE = new FieldType();

        static {
            FIELD_TYPE.setIndexOptions(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS);
            FIELD_TYPE.setTokenized(true);
            FIELD_TYPE.freeze();
        }
    }
}

