/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.index.engine;

import java.io.IOException;
import java.util.function.BiConsumer;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.search.ReferenceManager;
import org.easysearch.common.SuppressForbidden;
import org.easysearch.common.lucene.index.EasysearchDirectoryReader;

@SuppressForbidden(reason="reference counting is required here")
class EasysearchReaderManager
extends ReferenceManager<EasysearchDirectoryReader> {
    private final BiConsumer<EasysearchDirectoryReader, EasysearchDirectoryReader> refreshListener;

    EasysearchReaderManager(EasysearchDirectoryReader reader, BiConsumer<EasysearchDirectoryReader, EasysearchDirectoryReader> refreshListener) {
        this.current = reader;
        this.refreshListener = refreshListener;
        refreshListener.accept((EasysearchDirectoryReader)((Object)this.current), null);
    }

    protected void decRef(EasysearchDirectoryReader reference) throws IOException {
        reference.decRef();
    }

    protected EasysearchDirectoryReader refreshIfNeeded(EasysearchDirectoryReader referenceToRefresh) throws IOException {
        EasysearchDirectoryReader reader = (EasysearchDirectoryReader)DirectoryReader.openIfChanged((DirectoryReader)referenceToRefresh);
        if (reader != null) {
            this.refreshListener.accept(reader, referenceToRefresh);
        }
        return reader;
    }

    protected boolean tryIncRef(EasysearchDirectoryReader reference) {
        return reference.tryIncRef();
    }

    protected int getRefCount(EasysearchDirectoryReader reference) {
        return reference.getRefCount();
    }
}

