/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.index.analysis;

import java.util.List;
import java.util.function.Function;
import org.apache.lucene.analysis.TokenStream;
import org.easysearch.index.analysis.AnalysisMode;
import org.easysearch.index.analysis.CharFilterFactory;
import org.easysearch.index.analysis.TokenizerFactory;

public interface TokenFilterFactory {
    public static final TokenFilterFactory IDENTITY_FILTER = new TokenFilterFactory(){

        @Override
        public String name() {
            return "identity";
        }

        @Override
        public TokenStream create(TokenStream tokenStream) {
            return tokenStream;
        }
    };

    public String name();

    public TokenStream create(TokenStream var1);

    default public TokenStream normalize(TokenStream tokenStream) {
        return tokenStream;
    }

    default public boolean breaksFastVectorHighlighter() {
        return false;
    }

    default public TokenFilterFactory getChainAwareTokenFilterFactory(TokenizerFactory tokenizer, List<CharFilterFactory> charFilters, List<TokenFilterFactory> previousTokenFilters, Function<String, TokenFilterFactory> allFilters) {
        return this;
    }

    default public TokenFilterFactory getSynonymFilter() {
        return this;
    }

    default public AnalysisMode getAnalysisMode() {
        return AnalysisMode.ALL;
    }
}

