/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.index;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.easysearch.common.lease.Releasable;
import org.easysearch.common.settings.Setting;
import org.easysearch.common.settings.Settings;
import org.easysearch.common.unit.ByteSizeValue;
import org.easysearch.common.util.concurrent.EsRejectedExecutionException;
import org.easysearch.index.stats.IndexingPressureStats;

public class IndexingPressure {
    public static final Setting<ByteSizeValue> MAX_INDEXING_BYTES = Setting.memorySizeSetting("indexing_pressure.memory.limit", "10%", Setting.Property.NodeScope);
    private static final Logger logger = LogManager.getLogger(IndexingPressure.class);
    private final AtomicLong currentCombinedCoordinatingAndPrimaryBytes = new AtomicLong(0L);
    private final AtomicLong currentCoordinatingBytes = new AtomicLong(0L);
    private final AtomicLong currentPrimaryBytes = new AtomicLong(0L);
    private final AtomicLong currentReplicaBytes = new AtomicLong(0L);
    private final AtomicLong totalCombinedCoordinatingAndPrimaryBytes = new AtomicLong(0L);
    private final AtomicLong totalCoordinatingBytes = new AtomicLong(0L);
    private final AtomicLong totalPrimaryBytes = new AtomicLong(0L);
    private final AtomicLong totalReplicaBytes = new AtomicLong(0L);
    private final AtomicLong coordinatingRejections = new AtomicLong(0L);
    private final AtomicLong primaryRejections = new AtomicLong(0L);
    private final AtomicLong replicaRejections = new AtomicLong(0L);
    private final long primaryAndCoordinatingLimits;
    private final long replicaLimits;

    public IndexingPressure(Settings settings) {
        this.primaryAndCoordinatingLimits = MAX_INDEXING_BYTES.get(settings).getBytes();
        this.replicaLimits = (long)((double)this.primaryAndCoordinatingLimits * 1.5);
    }

    private static Releasable wrapReleasable(Releasable releasable) {
        AtomicBoolean called = new AtomicBoolean();
        return () -> {
            if (called.compareAndSet(false, true)) {
                releasable.close();
            } else {
                logger.error("IndexingPressure memory is adjusted twice", (Throwable)new IllegalStateException("Releasable is called twice"));
                assert (false) : "IndexingPressure is adjusted twice";
            }
        };
    }

    public Releasable markCoordinatingOperationStarted(long bytes, boolean forceExecution) {
        long combinedBytes = this.currentCombinedCoordinatingAndPrimaryBytes.addAndGet(bytes);
        long replicaWriteBytes = this.currentReplicaBytes.get();
        long totalBytes = combinedBytes + replicaWriteBytes;
        if (!forceExecution && totalBytes > this.primaryAndCoordinatingLimits) {
            long bytesWithoutOperation = combinedBytes - bytes;
            long totalBytesWithoutOperation = totalBytes - bytes;
            this.currentCombinedCoordinatingAndPrimaryBytes.getAndAdd(-bytes);
            this.coordinatingRejections.getAndIncrement();
            throw new EsRejectedExecutionException("rejected execution of coordinating operation [coordinating_and_primary_bytes=" + bytesWithoutOperation + ", replica_bytes=" + replicaWriteBytes + ", all_bytes=" + totalBytesWithoutOperation + ", coordinating_operation_bytes=" + bytes + ", max_coordinating_and_primary_bytes=" + this.primaryAndCoordinatingLimits + "]", false);
        }
        this.currentCoordinatingBytes.getAndAdd(bytes);
        this.totalCombinedCoordinatingAndPrimaryBytes.getAndAdd(bytes);
        this.totalCoordinatingBytes.getAndAdd(bytes);
        return IndexingPressure.wrapReleasable(() -> {
            this.currentCombinedCoordinatingAndPrimaryBytes.getAndAdd(-bytes);
            this.currentCoordinatingBytes.getAndAdd(-bytes);
        });
    }

    public Releasable markPrimaryOperationLocalToCoordinatingNodeStarted(long bytes) {
        this.currentPrimaryBytes.getAndAdd(bytes);
        this.totalPrimaryBytes.getAndAdd(bytes);
        return IndexingPressure.wrapReleasable(() -> this.currentPrimaryBytes.getAndAdd(-bytes));
    }

    public Releasable markPrimaryOperationStarted(long bytes, boolean forceExecution) {
        long combinedBytes = this.currentCombinedCoordinatingAndPrimaryBytes.addAndGet(bytes);
        long replicaWriteBytes = this.currentReplicaBytes.get();
        long totalBytes = combinedBytes + replicaWriteBytes;
        if (!forceExecution && totalBytes > this.primaryAndCoordinatingLimits) {
            long bytesWithoutOperation = combinedBytes - bytes;
            long totalBytesWithoutOperation = totalBytes - bytes;
            this.currentCombinedCoordinatingAndPrimaryBytes.getAndAdd(-bytes);
            this.primaryRejections.getAndIncrement();
            throw new EsRejectedExecutionException("rejected execution of primary operation [coordinating_and_primary_bytes=" + bytesWithoutOperation + ", replica_bytes=" + replicaWriteBytes + ", all_bytes=" + totalBytesWithoutOperation + ", primary_operation_bytes=" + bytes + ", max_coordinating_and_primary_bytes=" + this.primaryAndCoordinatingLimits + "]", false);
        }
        this.currentPrimaryBytes.getAndAdd(bytes);
        this.totalCombinedCoordinatingAndPrimaryBytes.getAndAdd(bytes);
        this.totalPrimaryBytes.getAndAdd(bytes);
        return IndexingPressure.wrapReleasable(() -> {
            this.currentCombinedCoordinatingAndPrimaryBytes.getAndAdd(-bytes);
            this.currentPrimaryBytes.getAndAdd(-bytes);
        });
    }

    public Releasable markReplicaOperationStarted(long bytes, boolean forceExecution) {
        long replicaWriteBytes = this.currentReplicaBytes.addAndGet(bytes);
        if (!forceExecution && replicaWriteBytes > this.replicaLimits) {
            long replicaBytesWithoutOperation = replicaWriteBytes - bytes;
            this.currentReplicaBytes.getAndAdd(-bytes);
            this.replicaRejections.getAndIncrement();
            throw new EsRejectedExecutionException("rejected execution of replica operation [replica_bytes=" + replicaBytesWithoutOperation + ", replica_operation_bytes=" + bytes + ", max_replica_bytes=" + this.replicaLimits + "]", false);
        }
        this.totalReplicaBytes.getAndAdd(bytes);
        return IndexingPressure.wrapReleasable(() -> this.currentReplicaBytes.getAndAdd(-bytes));
    }

    public long getCurrentCombinedCoordinatingAndPrimaryBytes() {
        return this.currentCombinedCoordinatingAndPrimaryBytes.get();
    }

    public long getCurrentCoordinatingBytes() {
        return this.currentCoordinatingBytes.get();
    }

    public long getCurrentPrimaryBytes() {
        return this.currentPrimaryBytes.get();
    }

    public long getCurrentReplicaBytes() {
        return this.currentReplicaBytes.get();
    }

    public IndexingPressureStats stats() {
        return new IndexingPressureStats(this.totalCombinedCoordinatingAndPrimaryBytes.get(), this.totalCoordinatingBytes.get(), this.totalPrimaryBytes.get(), this.totalReplicaBytes.get(), this.currentCombinedCoordinatingAndPrimaryBytes.get(), this.currentCoordinatingBytes.get(), this.currentPrimaryBytes.get(), this.currentReplicaBytes.get(), this.coordinatingRejections.get(), this.primaryRejections.get(), this.replicaRejections.get(), this.primaryAndCoordinatingLimits);
    }
}

