/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.common.util.concurrent;

import java.util.concurrent.locks.Lock;
import org.easysearch.Assertions;
import org.easysearch.common.lease.Releasable;
import org.easysearch.common.unit.TimeValue;
import org.easysearch.index.engine.EngineException;

public class ReleasableLock
implements Releasable {
    private final Lock lock;
    private final ThreadLocal<Integer> holdingThreads;

    public ReleasableLock(Lock lock) {
        this.lock = lock;
        this.holdingThreads = Assertions.ENABLED ? new ThreadLocal() : null;
    }

    @Override
    public void close() {
        this.lock.unlock();
        assert (this.removeCurrentThread());
    }

    public ReleasableLock acquire() throws EngineException {
        this.lock.lock();
        assert (this.addCurrentThread());
        return this;
    }

    public ReleasableLock tryAcquire() {
        boolean locked = this.lock.tryLock();
        if (locked) {
            assert (this.addCurrentThread());
            return this;
        }
        return null;
    }

    public ReleasableLock tryAcquire(TimeValue timeout) throws InterruptedException {
        boolean locked = this.lock.tryLock(timeout.duration(), timeout.timeUnit());
        if (locked) {
            assert (this.addCurrentThread());
            return this;
        }
        return null;
    }

    private boolean addCurrentThread() {
        Integer current = this.holdingThreads.get();
        this.holdingThreads.set(current == null ? 1 : current + 1);
        return true;
    }

    private boolean removeCurrentThread() {
        Integer count = this.holdingThreads.get();
        assert (count != null && count > 0);
        if (count == 1) {
            this.holdingThreads.remove();
        } else {
            this.holdingThreads.set(count - 1);
        }
        return true;
    }

    public boolean isHeldByCurrentThread() {
        if (this.holdingThreads == null) {
            throw new UnsupportedOperationException("asserts must be enabled");
        }
        Integer count = this.holdingThreads.get();
        return count != null && count > 0;
    }
}

