/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.common.settings;

import java.nio.file.Path;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.easysearch.cli.KeyStoreAwareCommand;
import org.easysearch.cli.Terminal;
import org.easysearch.cli.UserException;
import org.easysearch.common.settings.KeyStoreWrapper;
import org.easysearch.common.settings.SecureString;
import org.easysearch.env.Environment;

public abstract class BaseKeyStoreCommand
extends KeyStoreAwareCommand {
    private KeyStoreWrapper keyStore;
    private SecureString keyStorePassword;
    private final boolean keyStoreMustExist;
    OptionSpec<Void> forceOption;

    public BaseKeyStoreCommand(String description, boolean keyStoreMustExist) {
        super(description);
        this.keyStoreMustExist = keyStoreMustExist;
    }

    @Override
    protected final void execute(Terminal terminal, OptionSet options, Environment env) throws Exception {
        try {
            Path configFile = env.configFile();
            this.keyStore = KeyStoreWrapper.load(configFile);
            if (this.keyStore == null) {
                if (this.keyStoreMustExist) {
                    throw new UserException(65, "Easysearch keystore not found at [" + KeyStoreWrapper.keystorePath(env.configFile()) + "]. Use 'create' command to create one.");
                }
                if (!options.has(this.forceOption) && !terminal.promptYesNo("The easysearch keystore does not exist. Do you want to create it?", false)) {
                    terminal.println("Exiting without creating keystore.");
                    return;
                }
                this.keyStorePassword = new SecureString(new char[0]);
                this.keyStore = KeyStoreWrapper.create();
                this.keyStore.save(configFile, this.keyStorePassword.getChars());
            } else {
                this.keyStorePassword = this.keyStore.hasPassword() ? BaseKeyStoreCommand.readPassword(terminal, false) : new SecureString(new char[0]);
                this.keyStore.decrypt(this.keyStorePassword.getChars());
            }
            this.executeCommand(terminal, options, env);
        }
        catch (SecurityException e) {
            throw new UserException(65, e.getMessage());
        }
        finally {
            if (this.keyStorePassword != null) {
                this.keyStorePassword.close();
            }
        }
    }

    protected KeyStoreWrapper getKeyStore() {
        return this.keyStore;
    }

    protected SecureString getKeyStorePassword() {
        return this.keyStorePassword;
    }

    protected abstract void executeCommand(Terminal var1, OptionSet var2, Environment var3) throws Exception;
}

