/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.common.logging;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.layout.AbstractStringLayout;
import org.apache.logging.log4j.core.layout.ByteBufferDestination;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.easysearch.common.Strings;

@Plugin(name="ESJsonLayout", category="Core", elementType="layout", printObject=true)
public class ESJsonLayout
extends AbstractStringLayout {
    private final PatternLayout patternLayout;

    protected ESJsonLayout(String typeName, Charset charset, String[] esmessagefields) {
        super(charset);
        this.patternLayout = PatternLayout.newBuilder().withPattern(this.pattern(typeName, esmessagefields)).withAlwaysWriteExceptions(false).build();
    }

    private String pattern(String type, String[] esMessageFields) {
        if (Strings.isEmpty(type)) {
            throw new IllegalArgumentException("layout parameter 'type_name' cannot be empty");
        }
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("type", this.inQuotes(type));
        map.put("timestamp", this.inQuotes("%d{yyyy-MM-dd'T'HH:mm:ss,SSSZZ}"));
        map.put("level", this.inQuotes("%p"));
        map.put("component", this.inQuotes("%c{1.}"));
        map.put("cluster.name", this.inQuotes("${sys:es.logs.cluster_name}"));
        map.put("node.name", this.inQuotes("%node_name"));
        map.put("message", this.inQuotes("%notEmpty{%enc{%marker}{JSON} }%enc{%.-10000m}{JSON}"));
        for (String key : esMessageFields) {
            map.put(key, this.inQuotes("%ESMessageField{" + key + "}"));
        }
        return this.createPattern(map, Stream.of(esMessageFields).collect(Collectors.toSet()));
    }

    private String createPattern(Map<String, Object> map, Set<String> esMessageFields) {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        String separator = "";
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (esMessageFields.contains(entry.getKey())) {
                sb.append("%notEmpty{");
                sb.append(separator);
                this.appendField(sb, entry);
                sb.append("}");
            } else {
                sb.append(separator);
                this.appendField(sb, entry);
            }
            separator = ", ";
        }
        sb.append(this.notEmpty(", %node_and_cluster_id "));
        sb.append("%exceptionAsJson ");
        sb.append("}");
        sb.append(System.lineSeparator());
        return sb.toString();
    }

    private void appendField(StringBuilder sb, Map.Entry<String, Object> entry) {
        sb.append(this.jsonKey(entry.getKey()));
        sb.append(entry.getValue().toString());
    }

    private String notEmpty(String value) {
        return "%notEmpty{" + value + "}";
    }

    private CharSequence jsonKey(String s) {
        return this.inQuotes(s) + ": ";
    }

    private String inQuotes(String s) {
        return "\"" + s + "\"";
    }

    @PluginFactory
    public static ESJsonLayout createLayout(String type, Charset charset, String[] esmessagefields) {
        return new ESJsonLayout(type, charset, esmessagefields);
    }

    PatternLayout getPatternLayout() {
        return this.patternLayout;
    }

    @PluginBuilderFactory
    public static <B extends Builder<B>> B newBuilder() {
        return (B)((Object)((Builder)new Builder().asBuilder()));
    }

    public String toSerializable(LogEvent event) {
        return this.patternLayout.toSerializable(event);
    }

    public Map<String, String> getContentFormat() {
        return this.patternLayout.getContentFormat();
    }

    public void encode(LogEvent event, ByteBufferDestination destination) {
        this.patternLayout.encode(event, destination);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ESJsonLayout{");
        sb.append("patternLayout=").append(this.patternLayout);
        sb.append('}');
        return sb.toString();
    }

    public static class Builder<B extends Builder<B>>
    extends AbstractStringLayout.Builder<B>
    implements org.apache.logging.log4j.core.util.Builder<ESJsonLayout> {
        @PluginAttribute(value="type_name")
        String type;
        @PluginAttribute(value="charset", defaultString="UTF-8")
        Charset charset;
        @PluginAttribute(value="esmessagefields")
        private String esMessageFields;

        public Builder() {
            this.setCharset(StandardCharsets.UTF_8);
        }

        public ESJsonLayout build() {
            String[] split = Strings.isNullOrEmpty(this.esMessageFields) ? new String[]{} : this.esMessageFields.split(",");
            return ESJsonLayout.createLayout(this.type, this.charset, split);
        }

        public Charset getCharset() {
            return this.charset;
        }

        public B setCharset(Charset charset) {
            this.charset = charset;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public String getType() {
            return this.type;
        }

        public B setType(String type) {
            this.type = type;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public String getESMessageFields() {
            return this.esMessageFields;
        }

        public B setESMessageFields(String esmessagefields) {
            this.esMessageFields = esmessagefields;
            return (B)((Object)((Builder)this.asBuilder()));
        }
    }
}

