/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.common.inject;

import org.easysearch.common.inject.AbstractProcessor;
import org.easysearch.common.inject.MembersInjectorImpl;
import org.easysearch.common.inject.Provider;
import org.easysearch.common.inject.internal.Errors;
import org.easysearch.common.inject.internal.ErrorsException;
import org.easysearch.common.inject.spi.MembersInjectorLookup;
import org.easysearch.common.inject.spi.ProviderLookup;

class LookupProcessor
extends AbstractProcessor {
    LookupProcessor(Errors errors) {
        super(errors);
    }

    @Override
    public <T> Boolean visit(MembersInjectorLookup<T> lookup) {
        try {
            MembersInjectorImpl<T> membersInjector = this.injector.membersInjectorStore.get(lookup.getType(), this.errors);
            lookup.initializeDelegate(membersInjector);
        }
        catch (ErrorsException e) {
            this.errors.merge(e.getErrors());
        }
        return true;
    }

    @Override
    public <T> Boolean visit(ProviderLookup<T> lookup) {
        try {
            Provider<T> provider = this.injector.getProviderOrThrow(lookup.getKey(), this.errors);
            lookup.initializeDelegate(provider);
        }
        catch (ErrorsException e) {
            this.errors.merge(e.getErrors());
        }
        return true;
    }
}

